/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.eclipsewtp.docbook;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core
                                                   .IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core
                                                   .IValidatorJob;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DocbookValidator implements IValidatorJob {

  public ISchedulingRule getSchedulingRule(IValidationContext helper) {
    return null;
  }

  public IStatus validateInJob(IValidationContext helper, 
     IReporter reporter) throws ValidationException {
    final DocbookValidator validator = this;
    final IReporter theReporter = reporter;
    String[] uris = helper.getURIs();
    for (int i = 0; i < uris.length && !reporter.isCancelled(); i++) {
      String filename = uris[i];
      filename = filename.substring(filename.indexOf("/", 1));
      Object[] parms = { filename };

      final IFile file = (IFile) helper.loadModel("getFile", parms);
      Document doc = null;
      try {
        DocumentBuilderFactory domFactory = DocumentBuilderFactory
           .newInstance();
        DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
        domBuilder.setErrorHandler(new org.xml.sax.ErrorHandler() {
          public void error(SAXParseException e) 
             throws SAXException {
       	    reportMessage(LocalizedMessage.NORMAL_SEVERITY, 
               e.getLocalizedMessage(), e.getLineNumber());
           }
           public void fatalError(SAXParseException e) 
              throws SAXException {
       	     reportMessage(LocalizedMessage.HIGH_SEVERITY, 
       	        e.getLocalizedMessage(), e.getLineNumber());
           }
           public void warning(SAXParseException e) 
              throws SAXException {
       	     reportMessage(LocalizedMessage.LOW_SEVERITY, 
                e.getLocalizedMessage(), e.getLineNumber());
           }
           private void reportMessage(int severity, String message, 
              int lineno) {
       	     LocalizedMessage lMessage = new LocalizedMessage(
       	        severity, message, file);
       	     lMessage.setLineNo(lineno);
       	     theReporter.addMessage(validator, lMessage);
           }
        });
        doc = domBuilder.parse(file.getRawLocation().toFile());
      } 
      catch (Exception e) {
      }
      if (doc != null) {
        Element rootElem = doc.getDocumentElement();
        String rootName = rootElem.getNodeName();
        if (!"chapter".equals(rootName) && !"set".equals(rootName)
           && !"book".equals(rootName)
           && !"preface".equals(rootName)
           && !"appendix".equals(rootName)
           && !"glossary".equals(rootName)
           && !"bibliography".equals(rootName)
           && !"article".equals(rootName)) {
          LocalizedMessage message = new LocalizedMessage(
          LocalizedMessage.HIGH_SEVERITY,
             "Dokumenty DocBook musz zaczyna si od elementw: " +
             "appendix, article, bibliography, " +
             "book, chapter, glossary, preface albo set.", file);
          message.setLineNo(1);
          reporter.addMessage(this, message);
        }
      }
    }
    return Status.OK_STATUS;
  }

  public void cleanup(IReporter reporter) {
    // Brak operacji porzdkujcych dla walidatora DocBook.
  }

  public void validate(IValidationContext helper, IReporter reporter)
     throws ValidationException {
    // metoda dla walidatorw, ktre nie s uruchamiane jako zadania;
    // w przypadku walidatora DocBook nie trzeba jej implementowa.
  }
}