<!--
/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
-->
<%@ page language="java" contentType="text/html; charset=ISO-8859-2"
	pageEncoding="ISO-8859-2" session="true"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@page import="com.leagueplanet.ui.GameFormat"%>
<html>
<head>
<jsp:useBean class="com.leagueplanet.GameDetail" id="gameDetail"
	scope="session"></jsp:useBean>
<title>Wprowadzanie wyniku</title>
<link rel="stylesheet" href="schedule.css" type="text/css">
<link rel="stylesheet" href="validator.css" type="text/css">
<%
	GameFormat gameFormat = new GameFormat(gameDetail);

	long scheduleId = gameDetail.getScheduleId();
	String scheduleUrl = "schedule?scheduleId=" + scheduleId;
%>
</head>
<body onload="validateFields()">
<h1>Prosz wprowadzi wynik meczu:</h1>

<script type="text/javascript" src="score-validator.js">
</script>

<form name="enterScore" action="updateScore" method="post"
	onsubmit="return submitScore()" onreset="resetValidators()"><input
	name="gameId" type="hidden"
	value="<jsp:getProperty name="gameDetail" property="gameId" />" />

<table>
	<tr>
		<th align="right">Liga:</th>
		<td><jsp:getProperty name="gameDetail" property="leagueName" />
		</td>
	</tr>

	<tr>
		<th align="right">Terminarz:</th>
		<td><a href="<%= scheduleUrl %>"> <jsp:getProperty
			name="gameDetail" property="scheduleName" /></a></td>
	</tr>

	<tr>
		<th align="right">Data:</th>
		<td><%=gameFormat.getDateString()%></td>
	</tr>

	<tr>
		<th align="right">Godzina:</th>
		<td><%=gameFormat.getTimeString()%></td>
	</tr>

	<tr>
		<th align="right">Arena:</th>
		<td><jsp:getProperty name="gameDetail" property="locationName" />
		</td>
	</tr>

	<tr>
		<th align="right">Gocie:</th>
		<td><input id="visitorId" name="visitorScore"
			value="<jsp:getProperty name="gameDetail" property="visitorScore" />"
			size="2" maxlength="2" onchange="validateVisitor()">&nbsp; <jsp:getProperty
			name="gameDetail" property="visitorName" /></td>
		<td><span id="visitorValidator" class="validator"></span></td>
	</tr>

	<tr>
		<th align="right">Gospodarze:</th>
		<td><input id="homeId" name="homeScore"
			value="<jsp:getProperty name="gameDetail" property="homeScore" />"
			size="2" maxlength="2" onchange="validateHome()">&nbsp; <jsp:getProperty
			name="gameDetail" property="homeName" /></td>
		<td><span id="homeValidator" class="validator"></span></td>
	</tr>

	<tr>
		<td colspan="2">&nbsp;</td>
		<td>
		<button type="reset">Wyczy</button>
		&nbsp;
		<button type="submit">Przelij</button>
		</td>
	</tr>

</table>

</form>

</body>
</html>
