/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.ejb3;

import java.util.Set;
import javax.ejb.*;   
import javax.annotation.*;

import com.leagueplanet.model.*;
import com.leagueplanet.services.IceHockeyFacade;
import com.leagueplanet.services.LeagueFacade;

/**
* bezstanowy komponent sesyjny.
*/
@Stateless
@Remote(LeagueFacade.class)
public class LeagueFacade implements LeagueFacade {

	private LeagueFacade leagueFacade;

	@Init
	public void init() {
		leagueFacade = IceHockeyFacade.getLeagueFacade();
	}


	public boolean createLeague(League newLeague) {
		return leagueFacade.createLeague(newLeague);
	}
	public boolean doesLeagueExist(String name) {
		return leagueFacade.doesLeagueExist(name);
	}
	public Game findGame(long id) {
		return leagueFacade.findGame(id);
	}
	public League findLeague(long id) {
		return leagueFacade.findLeague(id);
	}
	public Location findLocation(long id) {
		return leagueFacade.findLocation(id);
	}
	public Player findPlayer(long id) {
		return leagueFacade.findPlayer(id);
	}
	public Schedule findSchedule(long id) {
		return leagueFacade.findSchedule(id);
	}
	public Team findTeam(long id) {
		return leagueFacade.findTeam(id);
	}
	public Set getSchedulesForLeague(String league) {
		return leagueFacade.getSchedulesForLeague(league);
	}
}
