/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.servlet;

import java.io.IOException;

import javax.jms.*;
import javax.naming.NamingException;
import javax.servlet.*;
import javax.servlet.http.*;

import com.leagueplanet.mdb.AsyncLeagueFacadeUtil;
import com.leagueplanet.model.League;

public class CreateLeagueAction extends HttpServlet
		implements Servlet {
	private final static int SESSIONTYPE = Session.AUTO_ACKNOWLEDGE;

	public CreateLeagueAction() {
		super();
	}

	public void doGet(HttpServletRequest request,
			HttpServletResponse response)
			throws ServletException, IOException {
		try {

			String leagueName = request
					.getParameter("league.name");
			sendMessage(leagueName);
			forward(request, response);

		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private void sendMessage(String leagueName)
			throws NamingException, JMSException {
		QueueConnection qConnection = AsyncLeagueFacadeUtil
				.getQueueConnection();
		Queue queue = AsyncLeagueFacadeUtil.getQueue();
		QueueSession qSession = qConnection
				.createQueueSession(false, SESSIONTYPE);
		QueueSender qSender = qSession.createSender(queue);

		League league = new League();
		league.setName(leagueName);

		ObjectMessage objectMessage = qSession
				.createObjectMessage(league);
		qSender.send(objectMessage);
		qSession.close();
		qConnection.close();
	}

	private void forward(HttpServletRequest request,
			HttpServletResponse response)
			throws ServletException, IOException {
		this.getServletContext().getRequestDispatcher(
				"/schedule.jsp").forward(request, response);
	}
}