/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Servlet implementation class for Servlet: LoginServlet
 * 
 */
public class LoginServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {

	private static final long serialVersionUID = 1L;

	protected User getUser(HttpServletRequest request) {

		// pozyskanie obiektu biecej sesji albo utworzenie nowego
		HttpSession session = request.getSession(true);

		// pozyskanie obiektu uytkownika i dodanie go do sesji
		User user = (User) session.getAttribute("user");
		if (user == null) {
			user = new User();
			session.setAttribute("user", user);
		}

		return user;
	}

	protected void forward(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		User user = getUser(request);
		String url = user.isLoggedIn() ? "/logout.jsp" : "/login.jsp";

		ServletContext context = getServletContext();
		RequestDispatcher dispatcher = context.getRequestDispatcher(url);
		dispatcher.forward(request, response);
	}

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		forward(request, response);
	}

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		User user = getUser(request);

		String userId = request.getParameter("userId");
		if (userId == null)
			userId = "";
		request.setAttribute("userId", userId);

		String password = request.getParameter("password");
		if (password == null)
			password = "";

		String action = request.getParameter("action");
		if (action == null)
			action = "Login";

		if (action.equals("Logout")) {
			user.logOut();
		} else {
			if (userId.length() < 2) {
				request.setAttribute("userIdMessage",
						"Identyfikator uytkownika musi mie przynajmniej 2 znaki!");
			} else {
				if (!password.equals("guest")) {
					request.setAttribute("passwordMessage",
							"Niepoprawne haso! Sprbuj: guest");
				} else {
					user.logIn(userId);
				}
			}
		}

		forward(request, response);
	}
}