<!--
/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
-->
<%@ page language="java" contentType="text/html; charset=ISO-8859-2"
    pageEncoding="ISO-8859-2"%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<jsp:useBean class="com.leagueplanet.HockeyGame" id="game" scope="session"></jsp:useBean>
<title>Enter Score</title>
<link rel="stylesheet" href="schedule.css" type="text/css">
<link rel="stylesheet" href="validator.css" type="text/css">
</head>
<body onload="validateFields()">
<p><%= new java.util.Date().toString() %>
<h1>Prosz wprowadzi wynik meczu:</h1>

<script type="text/javascript" src="score-validator.js">
</script>

<form name="enterScore" action="confirmation.html" method="get"
	onsubmit="return submitScore()" onreset="resetValidators()">

<table>
	<tr>
		<th align="right">Liga:</th>
		<td><jsp:getProperty name="game" property="league" /></td>
	</tr>

	<tr>
		<th align="right">Terminarz:</th>
		<td><jsp:getProperty name="game" property="scheduleName" /></td>
	</tr>

	<tr>
		<th align="right">Data:</th>
		<td colspan="3"><jsp:getProperty name="game" property="date" /></td>
	</tr>

	<tr>
		<th align="right">Godzina:</th>
		<td><jsp:getProperty name="game" property="time" /></td>
	</tr>

	<tr>
		<th align="right">Arena:</th>
		<td><jsp:getProperty name="game" property="arena" /></td>
	</tr>

	<tr>
		<th align="right">Gocie:</th>
		<td><input id="visitorId" name="visitorgoals" value="<jsp:getProperty name="game" property="visitorGoals" />" size="2"
			maxlength="2" onchange="validateVisitor()">&nbsp;<jsp:getProperty name="game" property="visitor" /></td>
		<td><span id="visitorValidator" class="validator" /></td>
	</tr>

	<tr>
		<th align="right">Gospodarze:</th>
		<td><input id="homeId" name="homegoals" value="<jsp:getProperty name="game" property="homeGoals" />" size="2" maxlength="2"
			onchange="validateHome()">&nbsp;<jsp:getProperty name="game" property="home" /></td>
		<td><span id="homeValidator" class="validator" /></td>
	</tr>

	<tr>
		<td colspan="2">&nbsp;</td>
		<td>
		<button type="reset">Wyczy</button>
		&nbsp;
		<button type="submit">Zatwierd</button>
		</td>
	</tr>

</table>

</form>

</body>
</html>
