/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

/**
 * Servlet implementation class for Servlet: ScheduleServlet
 * 
 */
public class ScheduleServlet extends HttpServlet implements
		javax.servlet.Servlet {

	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) 
				throws ServletException, IOException {

		try {
			ServletContext context = getServletContext();
			InputStream xsl = context.getResourceAsStream("schedule.xsl");
			Source xslSource = new StreamSource(xsl);
			
			TransformerFactory factory = TransformerFactory.newInstance();
			Templates templates = factory.newTemplates(xslSource);
			Transformer transformer = templates.newTransformer();
			
			InputStream xml = context.getResourceAsStream("schedule.xml");
			Source xmlSource = new StreamSource(xml);
			
			PrintWriter out = response.getWriter();
			Result htmlResult = new StreamResult(out);
			
			transformer.transform(xmlSource, htmlResult);
			
			response.flushBuffer();
			out.flush();
		} catch (TransformerException e) {
			throw new ServletException(e);
		}
	}
}