/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package org.eclipsewtp.wsdlextensions;

import java.util.List;

import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;

import org.eclipse.wst.wsdl.validation.internal.wsdl11
                                               .IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;

public class SOAPValidator implements IWSDL11Validator 
{
  public void validate(Object element, List parents,
                       IWSDL11ValidationInfo valInfo) {
    if(element instanceof UnknownExtensibilityElement) {
      UnknownExtensibilityElement soapElem = 
          (UnknownExtensibilityElement)element; 
      QName name = soapElem.getElementType();
      if(name.getLocalPart().equals("binding")) {
        String transport = soapElem.getElement()
                           .getAttribute("transport");
        if(transport == null || transport.equals("")) {
          valInfo.addError("Element wizania WTP SOAP musi posiada " +
                           "definicj atrybutu transport.", element);
        }
      }
    }
  }
}
