/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet;

import org.apache.cactus.ServletTestCase;

public class LoginServletTest extends ServletTestCase {

  private LoginServlet servlet;
  
  public void setUp() throws Exception {
    servlet = new LoginServlet();
  }

  public void tearDown() throws Exception {
    servlet.destroy();
  }

  public void testGetUser() {
    assertNull("Obiekt uytkownika ustawiony przed wywoaniem metody getUser().",
    		session.getAttribute("user"));
    User user = servlet.getUser(request);
    Object userObject = session.getAttribute("user");
    assertNotNull("Obiekt uytkownika jest pusty.", userObject);
    User retrievedUser = (User)userObject;
    assertEquals("Obiekt zwrcony przez getUser() nie jest zgodny " +
    	 "z obiektem przechowywanym w sesji.", user, retrievedUser);
  }
}