/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
/**
 * This class implements the update Web service.
 * 
 * @author Arthur Ryman
 */

package com.leagueplanet;

import com.leagueplanet.model.Game;
import com.leagueplanet.model.League;
import com.leagueplanet.model.Location;
import com.leagueplanet.model.Schedule;
import com.leagueplanet.model.Score;
import com.leagueplanet.model.Team;
import com.leagueplanet.services.IceHockeyFacade;
import com.leagueplanet.services.LeagueFacade;

public class Update {

	// w tej usudze wykorzystamy implementacj dla ligi hokejowej
	private LeagueFacade facade = IceHockeyFacade.getLeagueFacade();

	public void updateScore(long gameId, int visitorScore, int homeScore)
			throws GameException, ScoreException {

		Game game = facade.findGame(gameId);
		if (game == null)
			throw new GameException("Nieznana rozgrywka.", gameId);

		validateScore("visitor", visitorScore);
		validateScore("home", homeScore);

		game.getScore().setVisitor(visitorScore);
		game.getScore().setHome(homeScore);
	}

	private void validateScore(String team, int score) throws ScoreException {
		if (score < 0 || score > 99)
			throw new ScoreException("Wynik musi by liczb pomidzy 0 a 99.", team,
					score);
	}

	public GameDetail getGameDetail(long gameId) throws GameException {

		Game game = facade.findGame(gameId);
		if (game == null)
			throw new GameException("Nieznana rozgrywka.", gameId);

		GameDetail gameDetail = new GameDetail();
		gameDetail.setGameId(gameId);
		gameDetail.setDateTime(game.toCalendar());
		
		Schedule schedule = game.getSchedule();
		gameDetail.setScheduleId(schedule.getId());
		gameDetail.setScheduleName(schedule.getName());
		
		League league = schedule.getLeague();
		gameDetail.setLeagueId(league.getId());
		gameDetail.setLeagueName(league.getName());
		
		Location location = game.getLocation();
		gameDetail.setLocationId(location.getId());
		gameDetail.setLocationName(location.getName());
//		gameDetail.setLocationTimeZoneId(location.getTimeZoneId());
		
		Team visitor = game.getVisitor();
		gameDetail.setVisitorId(visitor.getId());
		gameDetail.setVisitorName(visitor.getName());
		
		Team home = game.getHome();
		gameDetail.setHomeId(home.getId());
		gameDetail.setHomeName(home.getName());
		
		Score score = game.getScore();
		gameDetail.setVisitorScore(score.getVisitor());
		gameDetail.setHomeScore(score.getHome());
		
		return gameDetail;
	}

}
