/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class League implements Serializable {

	private static final long serialVersionUID = 1L;

	private long id;

	private String name;

	private Set teams = new HashSet();

	private Set players = new HashSet();

	private Set schedules = new HashSet();
	
	public League() {
		this(0, "");
	}

	public League(long id, String name) {
		setId(id);
		setName(name);
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Set getPlayers() {
		return players;
	}

	public void setPlayers(Set players) {
		this.players = players;
	}

	public Set getTeams() {
		return teams;
	}

	public void setTeams(Set teams) {
		this.teams = teams;
	}

	public Set getSchedules() {
		return schedules;
	}

	public void setSchedules(Set schedules) {
		this.schedules = schedules;
	}
}
