/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.model;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;

public class Game extends Event implements Serializable {

	private static final long serialVersionUID = 1L;

	private Team home;

	private Team visitor;

	private Score score = new Score();

	public Game() {
		super();
	}

	public Game(long id, String date, String time) {
		super(id, "", date, time);
	}

	public Game(long id, Date date, Time time) {
		super(id, "", date, time);
	}

	public Team getHome() {
		return home;
	}

	public void setHome(Team home) {
		this.home = home;
	}

	public Score getScore() {
		return score;
	}

	public void setScore(Score score) {
		this.score = score;
	}

	public Team getVisitor() {
		return visitor;
	}

	public void setVisitor(Team visitor) {
		this.visitor = visitor;
	}

}
