/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.dao.example;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;

import com.leagueplanet.dao.LeagueDAO;
import com.leagueplanet.model.Game;
import com.leagueplanet.model.League;
import com.leagueplanet.model.Location;
import com.leagueplanet.model.Player;
import com.leagueplanet.model.Schedule;
import com.leagueplanet.model.Score;
import com.leagueplanet.model.Team;

public class IceHockeyJdbcDAOImpl implements LeagueDAO {

	// singleton DAO
	private static IceHockeyJdbcDAOImpl leagueDAO = null;

	public static LeagueDAO getLeagueDAO() {
		if (leagueDAO == null) {
			leagueDAO = new IceHockeyJdbcDAOImpl();
		}
		return leagueDAO;
	}

	private Connection openConnection() throws ClassNotFoundException,
			SQLException {
		Connection connection;
		Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
		connection = DriverManager
				.getConnection("jdbc:derby:D:\\leaguedb");
		return connection;
	}

	private void closeConnection(Connection connection) {
		if (connection != null)
			try {
				connection.close();
			} catch (SQLException e) {
			}
	}

	public League findLeague(long id) {
		// TODO: Add mappings for leagues and schedules
		League league = new League(id, "Modzieowa dziewczca liga hokejowa");
		league.getSchedules().add(findSchedule(1));
		return league;
	}

	public Schedule findSchedule(long id) {
		// TODO: Add mappings schedules
		Schedule schedule = new Schedule(id, "Sezon 2006/7");
		Connection connection = null;
		Statement statement = null;
		ResultSet resultset = null;
		try {
			connection = openConnection();
			String QUERY = "SELECT * FROM APP.GAME WHERE SCHEDULEID="
					+ id + " ORDER BY DATE ASC";
			statement = connection.createStatement();
			resultset = statement.executeQuery(QUERY);
			while (resultset.next()) {
				Game game = createGameFromResultSet(resultset);
				schedule.getEvents().add(game);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			closeConnection(connection);
		}
		return schedule;
	}

	private Game createGameFromResultSet(ResultSet rs)
			throws SQLException, ParseException {
		Game game = new Game();
		game.setId(rs.getInt("ID"));
		Calendar dateAndTime = Calendar.getInstance();
		Time time = rs.getTime("TIME");
		dateAndTime.setTime(rs.getDate("DATE"));
		dateAndTime.set(Calendar.HOUR_OF_DAY, time.getHours());
		dateAndTime.set(Calendar.MINUTE, time.getMinutes());
		game.setDateAndTime(dateAndTime);
		game.setLocation(new Location(0, rs.getString("ARENA")));
		Team homeTeam = new Team();
		homeTeam.setName(rs.getString("HOME"));
		game.setHome(homeTeam);
		Team visitorTeam = new Team();
		visitorTeam.setName(rs.getString("VISITOR"));
		game.setVisitor(visitorTeam);
		Score gameScore = new Score(Integer.parseInt(rs
				.getString("HOMESCORE")), Integer.parseInt(rs
				.getString("VISITORSCORE")));
		game.setScore(gameScore);
		return game;
	}

	// TODO: Add mappings later
	public Set getSchedulesForLeague(String league) {
		return null;
	}

	public Set findLeaguesWithName(String name) {
		return null;
	}

	public void save(League newLeague) {
	}

	public Game findGame(long id) {
		return null;
	}

	public Location findLocation(long id) {
		return null;
	}

	public Team findTeam(long id) {
		return null;
	}

	public Player findPlayer(long id) {
		return null;
	}
}
