/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.tests;

import com.leagueplanet.dao.example.IceHockeyDAOImpl;
import com.leagueplanet.model.League;
import com.leagueplanet.services.LeagueFacade;
import com.leagueplanet.services.impl.LeagueFacadeImpl;

import junit.framework.TestCase;

public class LeagueFacadeTest extends TestCase {
	LeagueFacade facade;

	public void setUp() throws Exception {
		super.setUp();
		facade = new LeagueFacadeImpl();
		((LeagueFacadeImpl) facade)
				.setLeagueDAO(IceHockeyDAOImpl
						.getLeagueDAO());
	}

	public void testDoesLeagueExist() {
		assertFalse(facade.doesLeagueExist("Przypadkowa nazwa"));
	}

	public void testCreateLeague() {
		League league = new League();
		league.setName("Liga testowa");
		assertTrue(facade.createLeague(league));
	}

}

