/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.services.impl;

import java.util.Set;

import com.leagueplanet.dao.LeagueDAO;
import com.leagueplanet.model.Game;
import com.leagueplanet.model.League;
import com.leagueplanet.model.Location;
import com.leagueplanet.model.Player;
import com.leagueplanet.model.Schedule;
import com.leagueplanet.model.Team;
import com.leagueplanet.services.LeagueFacade;

public class LeagueFacadeImpl implements LeagueFacade {
	private LeagueDAO leagueDAO;

	public LeagueDAO getLeagueDAO() {
		return leagueDAO;
	}

	public void setLeagueDAO(LeagueDAO leagueDAO) {
		this.leagueDAO = leagueDAO;
	}

	public boolean doesLeagueExist(String name) {
		Set allLeagues = leagueDAO
				.findLeaguesWithName(name);
		return allLeagues.size() > 0;
	}

	public boolean createLeague(League newLeague) {
		if (doesLeagueExist(newLeague.getName()))
			return false;
		leagueDAO.save(newLeague);
		return true;
	}

	public Set getSchedulesForLeague(String league) {
		return leagueDAO.getSchedulesForLeague(league);
	}

	public Game findGame(long id) {
		return leagueDAO.findGame(id);
	}

	public League findLeague(long id) {
		return leagueDAO.findLeague(id);
	}

	public Location findLocation(long id) {
		return leagueDAO.findLocation(id);
	}

	public Schedule findSchedule(long id) {
		return leagueDAO.findSchedule(id);
	}

	public Team findTeam(long id) {
		return leagueDAO.findTeam(id);
	}

	public Player findPlayer(long id) {
		return leagueDAO.findPlayer(id);
	}
}
