/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.model;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class Game implements Serializable {

	private static final long serialVersionUID = 1L;

	private long id;

	private String name;

	private Location location;

	private Calendar dateAndTime;

	private Schedule schedule;

	private Team home;

	private Team visitor;

	private Score score = new Score();

	public Game(long id, String name, Calendar dateAndTime) {
		setId(id);
		setName(name);
		setDateAndTime(dateAndTime);
	}

	public Game(long id, String name, String dateAndTime)
			throws ParseException {
		Calendar gameDateAndTime = Calendar.getInstance();
		SimpleDateFormat dateFormat = new SimpleDateFormat(
				"yyyy-mm-dd hh:mm:ss");
		gameDateAndTime.setTime(dateFormat
				.parse(dateAndTime));
		setId(id);
		setName(name);
		setDateAndTime(gameDateAndTime);
	}

	public Game() throws ParseException {
		this(0, "", "1970-01-01 00:00:00");
	}

	public Game(long id, String dateAndTime)
			throws ParseException {
		this(id, "", dateAndTime);
	}

	public Game(long id, Calendar dateAndTime) {
		this(id, "", dateAndTime);
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Location getLocation() {
		return location;
	}

	public void setLocation(Location location) {
		this.location = location;
	}

	public Schedule getSchedule() {
		return schedule;
	}

	public void setSchedule(Schedule schedule) {
		this.schedule = schedule;
	}

	public Team getHome() {
		return home;
	}

	public void setHome(Team home) {
		this.home = home;
	}

	public Score getScore() {
		return score;
	}

	public void setScore(Score score) {
		this.score = score;
	}

	public Team getVisitor() {
		return visitor;
	}

	public void setVisitor(Team visitor) {
		this.visitor = visitor;
	}

	public Calendar getDateAndTime() {
		return dateAndTime;
	}

	public void setDateAndTime(Calendar dateAndTime) {
		this.dateAndTime = dateAndTime;
	}

}
