/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet.dao;

import java.util.Set;

import com.leagueplanet.model.Game;
import com.leagueplanet.model.League;
import com.leagueplanet.model.Location;
import com.leagueplanet.model.Player;
import com.leagueplanet.model.Schedule;
import com.leagueplanet.model.Team;

public interface LeagueDAO {

	public Game findGame(long id);

	public League findLeague(long id);

	public Location findLocation(long id);

	public Player findPlayer(long id);

	public Schedule findSchedule(long id);

	public Team findTeam(long id);

	public Set getSchedulesForLeague(String league);

	public Set findLeaguesWithName(String name);

	public void save(League newLeague);

}
