/******************************************************************************* 
 * Copyright (c) 2005, 2007 Naci Dai, Lawrence Mandel, and Arthur Ryman. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * This sample developed for the book 
 *     Eclipse Web Tools Platform: Developing Java Web Applications
 * See http://eclipsewtp.org 
 *******************************************************************************/ 
package com.leagueplanet;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * Servlet implementation class for Servlet: EditScoreServlet
 * 
 */
public class EditScoreServlet extends javax.servlet.http.HttpServlet implements
		javax.servlet.Servlet {

	private static final long serialVersionUID = 1L;

	protected void doPost(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {

		// utworzenie obiektu meczu hokejowego na podstawie dania
		HockeyGame game = new HockeyGame();
		game.setLeague(request.getParameter("league"));
		game.setScheduleName(request.getParameter("schedulename"));
		game.setDate(request.getParameter("date"));
		game.setTime(request.getParameter("time"));
		game.setArena(request.getParameter("arena"));
		game.setVisitor(request.getParameter("visitor"));
		game.setHome(request.getParameter("home"));
		game.setVisitorGoals(Integer.parseInt(request
				.getParameter("visitorgoals")));
		game.setHomeGoals(Integer.parseInt(request.getParameter("homegoals")));

		// dodanie obiektu meczu do sesji
		HttpSession session = request.getSession(true);
		session.setAttribute("game", game);
		
		// przekierowanie dania do JSP
		ServletContext context = getServletContext();
		String url = "/score-form.jsp";
		RequestDispatcher dispatcher = context.getRequestDispatcher(url);
		dispatcher.forward(request, response);
	}
}