package org.eclipsebook.ch12.Ch1201.editors;

import java.io.StringWriter;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.*;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;

public class MultiPageEditor extends MultiPageEditorPart {

	private TextEditor editor;

	private StyledText text;

	public MultiPageEditor() {
		super();
	}

	void createPage0() {
		try {
			editor = new TextEditor();
			int index = addPage(editor, getEditorInput());
			setPageText(index, editor.getTitle());
		} catch (PartInitException e) {
			ErrorDialog.openError(
				getSite().getShell(),
				"Bd podczas tworzenia edytora",
				null,
				e.getStatus());
		}
	}

	void createPage1() {

		Composite composite = new Composite(getContainer(), SWT.NONE);
		FillLayout layout = new FillLayout();
		composite.setLayout(layout);
		text = new StyledText(composite, SWT.H_SCROLL | SWT.V_SCROLL);
		text.setEditable(false);

		int index = addPage(composite);
		setPageText(index, "Posortowane");
	}

	protected void createPages() {
		createPage0();
		createPage1();
	}

	public void doSave(IProgressMonitor monitor) {
		getEditor(0).doSave(monitor);
	}

	public void doSaveAs() {
		IEditorPart editor = getEditor(0);
		editor.doSaveAs();
		setPageText(0, editor.getTitle());
		setInput(editor.getEditorInput());
	}

	public void gotoMarker(IMarker marker) {
		setActivePage(0);
		getEditor(0).gotoMarker(marker);
	}

	public void init(IEditorSite site, IEditorInput editorInput)
		throws PartInitException {
		if (!(editorInput instanceof IFileEditorInput))
			throw new PartInitException("Invalid Input: Must be IFileEditorInput");
		super.init(site, editorInput);
	}

	public boolean isSaveAsAllowed() {
		return true;
	}

	protected void pageChange(int newPageIndex) {
		super.pageChange(newPageIndex);
		if (newPageIndex == 1) {
			sort();
		}
	}

	void sort() {
		String unsortedText =
			editor.getDocumentProvider().getDocument(editor.getEditorInput()).get();

		StringTokenizer stringTokenizer =
			new StringTokenizer(unsortedText, " \t\n\r");
		ArrayList wordArrayList = new ArrayList();
		while (stringTokenizer.hasMoreTokens()) {
			wordArrayList.add(stringTokenizer.nextToken());
		}

		Collections.sort(wordArrayList, Collator.getInstance());
		StringWriter sortedText = new StringWriter();
		for (int loopIndex = 0; loopIndex < wordArrayList.size(); loopIndex++) {
			sortedText.write(((String) wordArrayList.get(loopIndex)));
			sortedText.write(System.getProperty("line.separator"));
		}
		
		text.setText(sortedText.toString());
	}
}
