package org.eclipsebook.ch08;

import org.eclipse.swt.widgets.*;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;

public class Ch08_01 {

	Display display;
	Shell shell;
	Menu menuBar, fileMenu, helpMenu;
	MenuItem fileMenuHeader, helpMenuHeader;
	MenuItem fileExitItem, fileSaveItem, helpGetHelpItem;
	Label label;
	
    public Ch08_01(){
    
		display = new Display();
		shell = new Shell(display);
		shell.setText("Przykad: Menu");
		shell.setSize(300, 200);
		
		label = new Label(shell, SWT.CENTER);
		label.setBounds(shell.getClientArea());

		menuBar = new Menu(shell, SWT.BAR);
		fileMenuHeader = new MenuItem(menuBar, SWT.CASCADE);
		fileMenuHeader.setText("&Plik");
	
		fileMenu = new Menu(shell, SWT.DROP_DOWN);
		fileMenuHeader.setMenu(fileMenu);
	
		fileSaveItem = new MenuItem(fileMenu, SWT.PUSH);
		fileSaveItem.setText("&Zapisz");
	
		fileExitItem = new MenuItem(fileMenu, SWT.PUSH);
		fileExitItem.setText("Za&kocz");
	
		helpMenuHeader = new MenuItem(menuBar, SWT.CASCADE);
		helpMenuHeader.setText("&Pomoc");
	
		helpMenu = new Menu(shell, SWT.DROP_DOWN);
		helpMenuHeader.setMenu(helpMenu);
	
		helpGetHelpItem = new MenuItem(helpMenu, SWT.PUSH);
		helpGetHelpItem.setText("&Pomocy! ");
	
		fileExitItem.addSelectionListener(new fileExitItemListener());
		fileSaveItem.addSelectionListener(new fileSaveItemListener());
		helpGetHelpItem.addSelectionListener(new helpGetHelpItemListener());
	
		shell.setMenuBar(menuBar);
		shell.open();
		while(!shell.isDisposed()) {
			if(!display.readAndDispatch()) display.sleep();
		}
		display.dispose();
	}

	class fileExitItemListener implements SelectionListener
	{
	   public void widgetSelected(SelectionEvent event)
	   {
		  shell.close();
		  display.dispose();
	   }

	   public void widgetDefaultSelected(SelectionEvent event)
	   {
		  shell.close();
		  display.dispose();
	   }
	}

	class fileSaveItemListener implements SelectionListener
	{
	   public void widgetSelected(SelectionEvent event)
	   {
		label.setText("Zapisano");
	   }

	   public void widgetDefaultSelected(SelectionEvent event)
	   {
		label.setText("Zapisano");
	   }
	}

	class helpGetHelpItemListener implements SelectionListener
	{
	   public void widgetSelected(SelectionEvent event)
	   {
 		 label.setText("Pomoc nadchodzi!");
	   }

	   public void widgetDefaultSelected(SelectionEvent event)
	   {
		label.setText("Pomoc nadchodzi!");
	   }
	}

	public static void main(String [] args) {
        Ch08_01 menuExample = new Ch08_01();
	}
}
