<%
'
' ADOBE SYSTEMS INCORPORATED
' Copyright 2007 Adobe Systems Incorporated
' All Rights Reserved
' 
' NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the 
' terms of the Adobe license agreement accompanying it. If you have received this file from a 
' source other than Adobe, then your use, modification, or distribution of it requires the prior 
' written permission of Adobe.
'

'
'	Copyright (c) InterAKT Online 2000-2005
'

'
' This is the class responsable for generating and exporting the XML file.
'
Class XMLExport

  ' Internal array for storing the column that will be exported.
  Private columns

  ' The recordset from where the data will be exported.
  Private recordset

  ' The maximum number of records to be exported. It can be either the string 'ALL' or the actual number of records.
  Private maxRecords

  ' The encoding which will be set for the exported XML file.
  Private xmlEncoding

  ' The XML format. It can export the fields as either NODES or ATTRIBUTES.
  Private xmlFormat

  ' Array used to check if a column from the columns array exists in the recordset.
  Private columnsExists

  ' The name of the root element in the exported XML
  Private rootNodeName

  ' The name of the row element in the exported XML
  Private rowNodeName

  Private Sub Class_Initialize()
  End Sub

  Private Sub Class_Terminate()
  End Sub

  '
  ' Method that initializes the member variables to default values.
  '
  Public Sub Init ()
    maxRecords = "ALL"
    xmlFormat = "NODES"
    rootNodeName = "export"
    rowNodeName = "row"
    Set columns = Server.CreateObject("Scripting.Dictionary")
    Set columnsExists = Server.CreateObject("Scripting.Dictionary")
    Set Recordset = nothing	
  End Sub	

  '
  ' This is the setter for the recordset member variable.
  '
  ' @param rs__param The recordset from where to retrieve the data for the export.
  '
  Public sub setRecordset (ByRef rs__param)
    Set recordset = rs__param
  End Sub

  '
  ' This is the setter for the maxRecords member variable specifying how may records should be exported.
  '
  ' @param maxRecords_param The string 'ALL' or the number of records.
  '
  Public Sub setMaxRecords(maxRecords__param)
    maxRecords = Trim(maxRecords__param)
  End Sub

  '
  ' This is the setter for the xmlEncoding member variable.
  '
  ' @param xmlEncoding The encoding that will be set for the XML.
  '
  Public Sub setXMLEncoding(xmlEncoding__param)
    xmlEncoding = Trim(xmlEncoding__param)
  End Sub

  '
  ' This is the setter for the xmlFormat member variable.
  '
  ' @param xmlFormat__param The format in which the XML file should export the data: "NODES" or "ATTRIBUTES".
  '
  Public Sub setXMLFormat(xmlFormat__param)
    xmlFormat = Trim(UCase(xmlFormat__param))
    If xmlFormat <> "ATTRIBUTES" Then
      xmlFormat = "NODES"
    End If
  End Sub

  '
  ' This is the setter for the rootNodeName member variable.
  '
  ' @param rootNodeName__param The name of the root element in the resulting XML.
  '
  Public Sub setRootNode(rootNodeName__param)
    rootNodeName = Trim(rootNodeName__param)
  End Sub

  '
  ' This is the setter for the rowNodeName member variable.
  '
  ' @param rowNodeName__param The name of the row element in the resulting XML.
  '
  Public Sub setRowNode(rowNodeName__param)
    rowNodeName = Trim(rowNodeName__param)
  End Sub

  '
  ' This method adds a column to the member variable columns which holds the columns that the XML file will have.
  '
  ' @param column The name of the column as it appears in the recordset.
  ' @param label  The label that will be used in the exported XML file to identify this field.
  '
  Public Sub addColumn(column, label)
    Set columns(Trim(column)) = Server.CreateObject("Scripting.Dictionary")
    If Trim(label) <> "" Then
      columns(Trim(column))("label") = Trim(label)
    Else
      columns(Trim(column))("label") = Trim(column)
    End If
  End Sub

  '
  ' This method is the one that generates and exports the XML file.
  '
  Function Execute()
    If Not isObject(recordset) Then
      Response.write "<strong>XMLExport Error.</strong><br/>Passed argument is not a valid recordset."
      Exit Function
    End If

    If columns.Count = 0 Then
      Response.write "<strong>XMLExport Error.</strong><br/>No columns defined!"
      Exit Function
    End If


    ' build columnExists
    For Each column in columns
      If Not recordset.EOF Then
        On Error Resume Next
        value = recordset.Fields.Item(column).Value
        If err.Number <> 0 Then
          columnsExists(column) = False							
        Else
          columnsExists(column) = True
        End If
        On Error GoTo 0	
      End If
    Next

    numRow = 1
    Set row = new XML_Export_StringBuilder
    row.Concat "<" & "?xml version=""1.0"" encoding=""" & xmlEncoding & """?" & ">" & vbNewLine
    row.Concat "<" & rootNodeName & ">" & vbNewLine

    If Recordset.CursorType > 0 Then
      Recordset.MoveFirst
    Else
      Recordset.Requery
    End If
    Do While Not Recordset.EOF
      If maxRecords <> "ALL" Then
        If Cint(maxRecords) < numRow Then
	  Exit Do
        End If	
      End If
      row.Concat vbTab
      row.Concat "<" & rowNodeName
      If xmlFormat <> "ATTRIBUTES" Then
        row.Concat ">" & vbNewLine
      End If

      For each column in columns
        colName =  columns(column)("label")
        value = ""
        If columnsExists(column) Then
          value = recordset.Fields.Item(column).Value
        End If

        value = escapeValue(value)

        If xmlFormat = "ATTRIBUTES" Then
          row.Concat " " & colName & "=""" & value & """"
        Else	
          row.Concat vbTab & vbTab & "<" & colName & ">" & value & "</" & colName & ">" & vbNewLine
        End If
      Next

      If xmlFormat = "ATTRIBUTES" Then
        row.Concat " />"
      Else
        row.Concat vbTab & "</" & rowNodeName & ">"
      End If
      row.Concat vbNewLine
      numRow = numRow + 1
      Recordset.Movenext
    Loop
    row.Concat "</" & rootNodeName & ">"

    document = row.ToString()
    sendHeaders()
    Response.write document
    Response.Flush()
    Response.End()
  End Function

  '
  ' This method is used to send the appropriate headers.
  '
  '
  Private Sub sendHeaders()
    Response.ContentType = "text/xml; charset=" & xmlEncoding
    Response.AddHeader "Pragma", "public"
    Response.AddHeader "Cache-control", "private"
    Response.AddHeader "Expires", "-1"
  End Sub

  '
  ' This method is used to escape the values before they are exported so that the XML is valid.
  '
  ' @param valueStr The string to be escaped.
  '
  ' @returns The escaped value which is valid in an XML files.
  '
  Private Function escapeValue (valueStr)
    If isNull(valueStr) Or len(valueStr)=0 Then 
      escapeValue = ""
      Exit Function
    End If
    escapeValue = replace(valueStr, "&", "&amp;")
    escapeValue = replace(escapeValue, ">", "&gt;")
    escapeValue = replace(escapeValue, "<", "&lt;")
    escapeValue = replace(escapeValue, """", "&quot;")
  End Function

End Class

Class XML_Export_StringBuilder
  Dim arr	    'the array of strings to concatenate
  Dim growthRate  'the rate at which the array grows
  Dim itemCount   'the number of items in the array

  Private Sub Class_Initialize()
    growthRate = 50
    itemCount = 0
    ReDim arr(growthRate)
  End Sub

  Public Sub Concat(ByVal strValue)
    If itemCount > UBound(arr) Then
      ReDim Preserve arr(UBound(arr) + growthRate)
    End If

    arr(itemCount) = strValue & ""
    itemCount = itemCount + 1
  End Sub

  Public Function ToString() 
    ToString = Join(arr, "")
  End Function
End Class
%>
