<cfcomponent>
<!---
  ADOBE SYSTEMS INCORPORATED
  Copyright 2007 Adobe Systems Incorporated
  All Rights Reserved
 
  NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the 
  terms of the Adobe license agreement accompanying it. If you have received this file from a 
  source other than Adobe, then your use, modification, or distribution of it requires the prior 
  written permission of Adobe.
--->

<!---
    Copyright (c) InterAKT Online 2000-2005
 --->

<!---
/**
 *  This is the method that initializes the member variables to default values.
 */
--->
    <cffunction name="init" access="public" output="no">
	<cfset this.columns = StructNew()>
	<cfset this.maxRecords = "ALL">
        <cfset this.xmlEncoding = "ISO-8859-1">
        <cfset this.rootNodeName = "export">
        <cfset this.rowNodeName = "row">
	<cfset this.xmlFormat = "NODES">
	<cfset this.columnsOrder = ArrayNew(1)>
    </cffunction>
	
    <!---
    /**
     * This is the setter for the recordset member variable.
     *
     * @param recordset The recordset from where to retrieve the data for the export.
     */
    --->
    <cffunction name="setRecordset" access="public" output="no">
	<cfargument name="recordset" type="query" required="yes">
	<cfset this.recordset = Arguments.recordset>
    </cffunction>

    <!---
    /**
     * This is the setter for the maxRecords member variable specifying how may records should be exported.
     * 
     * @param maxRecords The string 'ALL' or the number of records.
     */
    --->
    <cffunction name="setMaxRecords" access="public" output="no">
	<cfargument name="maxRecords" type="string" required="yes">
	<cfset this.maxRecords = Trim(Arguments.maxRecords)>
    </cffunction>

    <!---
    /**
     * This is the setter for the xmlEncoding member variable.
     *
     * @param xmlEncoding The encoding that will be set for the XML.
     */
    --->
    <cffunction name="setXMLEncoding" access="public" output="no">
	<cfargument name="xmlEncoding" type="string" required="yes">
	<cfset this.xmlEncoding = Trim(Arguments.xmlEncoding)>
    </cffunction>

    <!---
    /**
     * This is the setter for the xmlFormat member variable.
     *
     * @param xmlFormat The format in which the XML file should export the data: "NODES" or "ATTRIBUTES".
     */
    --->
    <cffunction name="setXMLFormat" access="public" output="no">
	<cfargument name="xmlFormat" type="string" required="yes">
	<cfset this.xmlFormat = UCase(Trim(Arguments.xmlFormat))>
	<cfif this.xmlFormat NEQ "ATTRIBUTES">
	    <cfset this.xmlFormat = "NODES">
	</cfif>
    </cffunction>

   <!---
    /**
     * This is the setter for the rootNodeName member variable.
     * 
     * @param rootNodeName The name of the root element in the resulting XML.
     */
    --->
    <cffunction name="setRootNode" access="public" output="no">
	<cfargument name="rootNodeName" type="string" required="yes">
	<cfset this.rootNodeName = Trim(Arguments.rootNodeName)>
    </cffunction>

  <!---
    /**
     * This is the setter for the rowNodeName member variable.
     * 
     * @param rowNodeName The name of the row element in the resulting XML.
     */
    --->
    <cffunction name="setRowNode" access="public" output="no">
	<cfargument name="rowNodeName" type="string" required="yes">
	<cfset this.rowNodeName = Trim(Arguments.rowNodeName)>
    </cffunction>

    <!---
    /**
     * This method adds a column to the member variable columns which holds the columns that the XML file will have.
     *
     * @param column The name of the column as it appears in the recordset.
     * @param label  The label that will be used in the exported XML file to identify this field.
     */
    --->
    <cffunction name="addColumn" access="public" output="no">
	<cfargument name="column" type="string" required="yes">
	<cfargument name="label" type="string" required="no" default="">

	<cfset this.columns[Trim(Arguments.column)]["label"] = Trim(Arguments.label)>
	<cfset ArrayAppend(this.columnsOrder, Trim(Arguments.column))>
    </cffunction>

    <!---
    /**
     * This method is the one that generates and exports the XML file.
     */
    --->
    <cffunction name="Execute" access="public" output="no">
	<cfset var column = "">
	<cfset var value = "">
	<cfset var numRow = 1>
	<cfset var row = "">
	<cfset var index = 0>
	<cfset var document = "">
	<cfset var EOL = Chr(13) & Chr(10)>
	<cfset var TAB = Chr(9)>

	<cfif NOT isDefined("this.recordset")>
	    <cfoutput><strong>XMLExport Error.</strong><br/>Passed argument is not a valid query.</cfoutput>
	    <cfabort>
	</cfif>

	<cfif StructCount(this.columns) LT 1>
	    <cfoutput><strong>XMLExport Error.</strong><br/>No columns defined!</cfoutput>
	    <cfabort>
	</cfif>

	<cfset document = "<" & '?xml version="1.0" encoding="' & this.xmlEncoding & '"?' & ">">
	<cfset document = document & EOL>
	<cfset document = document & "<" & this.rootNodeName & ">">
	<cfset document = document & EOL>

	<cfloop query="this.recordset">
	    <cfif this.maxRecords NEQ "ALL" AND this.maxRecords LT numRow>
		<cfbreak>
	    </cfif>
	    <cfset row = TAB>
	    <cfset row = row & "<" & this.rowNodeName>
	    <cfif this.xmlFormat NEQ "ATTRIBUTES">
		<cfset row = row & ">" & EOL>
	    </cfif>

	    <cfloop from="1" to="#ArrayLen(this.columnsOrder)#" index="index">
		<cfset column = this.columnsOrder[index]>
		<cfset colName = column>
		<cfif this.columns[column]["label"] NEQ "">
		    <cfset colName = this.columns[column]["label"]>
		</cfif>

		<cfset value = "">
		<cfif StructKeyExists(this.recordset, column)>
		    <cfset value = this.recordset[column][this.recordset.CurrentRow]>
		</cfif>
		<cfset value = XMLFormat(value)>

		<cfif this.xmlFormat EQ "ATTRIBUTES">
		    <cfset row = row & " " & colName & '="'>
		    <cfset row = row & value>
		    <cfset row = row & '"'>
		<cfelse>
		    <cfset row = row & TAB & TAB>
		    <cfset row = row & "<" & colName & ">">
		    <cfset row = row & value>
		    <cfset row = row & "</" & colName & ">">
		    <cfset row = row & EOL>
		</cfif>
	    </cfloop>

	    <cfif this.xmlFormat EQ "ATTRIBUTES">
		<cfset row = row & " />">
	    <cfelse>
		<cfset row = row & TAB>
		<cfset row = row & "</" & this.rowNodeName & ">">
	    </cfif>
	    <cfset document = document & row>
	    <cfset document = document & EOL>
	    <cfset numRow = numRow + 1>
	</cfloop>
		
	<cfset document = document & "</" & this.rootNodeName & ">">

	<cfset this.sendHeaders()>
	<cfoutput>#document#</cfoutput>
	<cfabort>
    </cffunction>

    <!---
    /**
     * This method is used to send the appropriate headers.
     *
     * @param size__param The size of the XML being exported.
     */
    --->
    <cffunction name="sendHeaders" access="package" output="no">
	<cfheader name="Content-type" value="text/xml; charset=#this.xmlEncoding#">
	<cfheader name="Pragma" value="public">
	<cfheader name="Cache-control" value="private">
	<cfheader name="Expires" value="-1">
    </cffunction>
</cfcomponent>

