unit uTextFileViewer;

interface

uses
  Windows, Messages, SysUtils, Classes, HTTPApp, WebModu, HTTPProd,
  WebAdapt, WebComp, Dialogs;

type
  TTextFileViewer = class(TWebPageModule)
    PageProducer: TPageProducer;
    FileViewerAdapter: TAdapter;
    FileContent: TAdapterMemoField;
    FileViewerFields: TAdapterFields;
    FileName: TAdapterField;
    SelectFileName: TAdapterAction;
    dlgOpen: TOpenDialog;
    procedure FileContentGetValue(Sender: TObject; var Value: String);
    procedure FileNameGetValue(Sender: TObject; var Value: Variant);
    procedure SelectFileNameExecute(Sender: TObject; Params: TStrings);
  private
    FFileName: String;
    FFileContent: String;
  public
    { Public declarations }
  end;

  function TextFileViewer: TTextFileViewer;

implementation

{$R *.dfm}  {*.html}

uses WebReq, WebCntxt, WebFact, Variants;

function TextFileViewer: TTextFileViewer;
begin
  Result := TTextFileViewer(WebContext.FindModuleClass(TTextFileViewer));
end;

procedure TTextFileViewer.FileNameGetValue(Sender: TObject;  var Value: Variant);
begin
 Value := FFileName;
end;

procedure TTextFileViewer.FileContentGetValue(Sender: TObject; var Value: String);
begin
 if FFileName = ''
  then FFileContent := ''
  else
  try
   with TFileStream.Create(FFileName, fmOpenRead) do
   try
    SetString(FFileContent, nil, Size);
    Read(Pointer(FFileContent)^, Size);
   finally
    Free;
   end;
  except
   on E: Exception do FFileContent := E.Message;
  end;
 Value := FFileContent;
end;

procedure TTextFileViewer.SelectFileNameExecute(Sender: TObject; Params: TStrings);
begin
 if dlgOpen.Execute
  then FFileName := dlgOpen.FileName;
end;

initialization
  if WebRequestHandler <> nil then
    WebRequestHandler.AddWebModuleFactory(TWebPageModuleFactory.Create(TTextFileViewer, TWebPageInfo.Create([wpPublished , wpLoginRequired], '.html'), crOnDemand, caCache));
end.
