unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Rio, SOAPHTTPClient, SOAPHTTPTrans, SOAPDomConv,
  OPToSOAPDomConv, SOAPPasInv, SOAPHTTPPasInv;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    HTTPRIO1: THTTPRIO;
    meMessage: TMemo;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses Types, IntfSimpleEcho;

procedure TForm1.Button1Click(Sender: TObject);
var Port : ISimpleEcho;
begin
 try
  Port := GetISimpleEcho;
  ShowMessage( Port.echoString(meMessage.Lines[0] ) );
 finally
  Port := nil;
 end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 try
   ShowMessage( (HTTPRIO1 as ISimpleEcho).echoString( meMessage.Lines[0] ) );
 except
  on E:EEchoException do
   begin
    ShowMessage( 'Must not contain string: ' + E.Message + #13#10
    + E.FaultActor + #13#10 + E.FaultCode + #13#10+ E.FaultDetail );
   end;
 end;
end;

procedure Strings2DynArray( sl : TStrings; var sda : TStringDynArray );
var i: integer;
begin
 SetLength( sda, sl.Count );
 for i := 0 to sl.Count-1 do
  sda[i] := sl[i];
end;

procedure DynArray2Strings( sda : TStringDynArray; sl : TStrings );
var i: integer;
begin
  sl.Clear;
  for i := Low(sda) to High(sda) do
   sl.Add(sda[i]);
end;

procedure TForm1.Button3Click(Sender: TObject);
var a: TStringDynArray;
begin
 try
   Strings2DynArray( meMessage.Lines, a );
   (HTTPRIO1 as ISimpleEcho).echoStringArray( a );
   meMessage.Clear;
   DynArray2Strings( a, meMessage.Lines );
 finally
  SetLength( a, 0 );
 end;
end;

end.
