unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xmldom, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DB,
  Provider, Xmlxform, DBClient, ComCtrls, Buttons, XMLIntf, msxmldom,
  XMLDoc;

type
  TfmMain = class(TForm)
    paTop: TPanel;
    edXMLFileName: TEdit;
    Label1: TLabel;
    sbFileOpen: TSpeedButton;
    bbClose: TBitBtn;
    ClDataSet: TClientDataSet;
    XMLProvider: TXMLTransformProvider;
    DataSource: TDataSource;
    dlgOpen: TOpenDialog;
    XMLDoc: TXMLDocument;
    edReadFileName: TEdit;
    Label4: TLabel;
    sbFileRead: TSpeedButton;
    edWriteFileName: TEdit;
    Label5: TLabel;
    sbFileWrite: TSpeedButton;
    bbSave: TBitBtn;
    bbOpen: TBitBtn;
    PageControl1: TPageControl;
    tsXMLDoc: TTabSheet;
    tvXMLDoc: TTreeView;
    tsDataSet: TTabSheet;
    dbgXMLDataSet: TDBGrid;
    XMLClient: TXMLTransformClient;
    procedure bbSaveClick(Sender: TObject);
    procedure bbOpenClick(Sender: TObject);
    procedure sbFileOpenClick(Sender: TObject);
    procedure sbFileReadClick(Sender: TObject);
    procedure sbFileWriteClick(Sender: TObject);
  private
    procedure SetXMLNode(TreeNode: TTreeNode; XMLNode: IXMLNode);
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.dfm}

const AppTitle: String = 'XML Viewer';

procedure TfmMain.sbFileOpenClick(Sender: TObject);
begin
 dlgOpen.FilterIndex := 1;
 if dlgOpen.Execute
  then edXMLFileName.Text := dlgOpen.FileName;
end;

procedure TfmMain.sbFileReadClick(Sender: TObject);
begin
 dlgOpen.FilterIndex := 2;
 if dlgOpen.Execute
  then edReadFileName.Text := dlgOpen.FileName;
end;

procedure TfmMain.sbFileWriteClick(Sender: TObject);
begin
 dlgOpen.FilterIndex := 2;
 if dlgOpen.Execute
  then edWriteFileName.Text := dlgOpen.FileName;
end;

procedure TfmMain.SetXMLNode(TreeNode: TTreeNode; XMLNode: IXMLNode);
var i: Integer;
    NewNode: TTreeNode;

begin
 NewNode := tvXMLDoc.Items.AddChild(TreeNode, XMLNode.NodeName);
 if not Assigned(NewNode)
  then Abort;
 if Assigned(XMLNode.AttributeNodes) then
  for i := 0 to XMLNode.AttributeNodes.Count - 1  do
   tvXMLDoc.Items.AddChild(NewNode, XMLNode.AttributeNodes[i].NodeName +
                                    '='  +
                                    XMLNode.Attributes[XMLNode.AttributeNodes[i].NodeName]);
 if Assigned(XMLNode.ChildNodes) then
  for i := 0 to XMLNode.ChildNodes.Count - 1  do
   SetXMLNode(NewNode, XMLNode.ChildNodes[i]);
end;

procedure TfmMain.bbOpenClick(Sender: TObject);
var i: Integer;
begin
 if edXMLFileName.Text <> '' then
 begin
  ClDataSet.Close;
  XMLDoc.Active := False;
  tvXMLDoc.Items.Clear;
  XMLProvider.XMLDataFile := edXMLFileName.Text;
  XMLProvider.TransformRead.TransformationFile := edReadFileName.Text;
  XMLProvider.TransformWrite.TransformationFile := edWriteFileName.Text;
  try
   ClDataSet.Open;
   XMLDoc.XML.Clear;
   XMLDoc.XML.Add(XMLClient.GetDataAsXml(edReadFileName.Text));
   XMLDoc.Active := True;
   SetXMLNode(nil, XMLDoc.DocumentElement);
  except
   on E: Exception do
   begin
    tvXMLDoc.Items.Clear;
    ClDataSet.Close;
    XMLDoc.Active := False;
    Application.MessageBox(pChar(E.Message), pChar(AppTitle), MB_ICONERROR or MB_OK);
   end;
  end;
 end;
end;

procedure TfmMain.bbSaveClick(Sender: TObject);
begin
 ClDataSet.ApplyUpdates(-1);
end;

end.
