unit srvUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Buttons, ScktComp, ExtCtrls, ComCtrls;

type
  TServerForm = class(TForm)
    StatusBar1: TStatusBar;
    Bevel1: TBevel;
    ServerSocket: TServerSocket;
    Timer1: TTimer;
    ClientsListBox: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure ServerSocketClientConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure ServerSocketClientDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure Timer1Timer(Sender: TObject);
    procedure ServerSocketClientError(Sender: TObject;
      Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
      var ErrorCode: Integer);
  public
  end;

var
  ServerForm: TServerForm;

implementation

{$R *.DFM}

procedure TServerForm.FormCreate(Sender: TObject);
begin
  ServerSocket.Active := True;
  Statusbar1.SimpleText := 'Nasuchiwanie...'
end;

procedure TServerForm.Timer1Timer(Sender: TObject);
var i: Integer; s : string;
 ms : TMemoryStatus;
begin
 with ServerSocket.Socket do for i:=0 to ActiveConnections-1 do
  Connections[i].SendText('T' + FormatDateTime( 'hh-nn-ss', Time ));

  GlobalMemoryStatus(ms);
  s := Format('%10dK',[(ms.dwAvailPageFile + ms.dwAvailPhys) div 1024]);
 with ServerSocket.Socket do for i:=0 to ActiveConnections-1 do
  Connections[i].SendText('M' + s);
end;

procedure TServerForm.ServerSocketClientConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  ClientsListBox.Items.AddObject(
   Format('Connected to: %s', [Socket.RemoteAddress]),
   Socket);
  Statusbar1.SimpleText := 'Nasuchiwanie...'; 
end;

procedure TServerForm.ServerSocketClientDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
var i: Integer;
begin
  if ServerSocket.Socket.ActiveConnections=0 then ServerSocket.Active := False;
  for i := 0 to ClientsListBox.Count - 1 do
   if ClientsListBox.Items.Objects[i] = Socket then
    begin
     ClientsListBox.Items.Delete(i);
     break;
    end;
  Statusbar1.SimpleText := 'Nasuchiwanie...';  
end;

procedure TServerForm.ServerSocketClientError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin
   StatusBar1.SimpleText := Format('Bd w %s: %s',
   [Socket.RemoteAddress, SysErrorMessage(ErrorCode)] );
   ErrorCode := 0;
end;

end.
