{ Invokable implementation File for TSimpleEcho which implements ISimpleEcho }

unit SimpleEchoImpl;

interface

uses SysUtils, InvokeRegistry, Types,
        XSBuiltIns, IntfSimpleEcho;

type

  { TSimpleEcho }
  TSimpleEcho = class(TInvokableClass, ISimpleEcho)
  public
   function echoString(const Value: String): String; stdcall;
   function echoStringArray(const Value: TStringDynArray): TStringDynArray; stdcall;
  end;

implementation

 function TSimpleEcho.echoString(const Value: String): String;
 begin
  if AnsiCompareStr( Value, 'Error' ) = 0 then
   begin
    Result := 'Fault';
    raise EEchoException.Create( Value );
   end
  else
   Result := Value;
 end;

 function TSimpleEcho.echoStringArray(const Value: TStringDynArray): TStringDynArray;
 begin
  Result := Value;
 end;


initialization
  { Invokable classes must be registered }
  InvRegistry.RegisterInvokableClass(TSimpleEcho);

end.
