unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xmldom, XMLIntf, msxmldom, XMLDoc, StdCtrls, ComCtrls, ImgList,
  Grids, ValEdit, ExtCtrls, StdActns, ActnList, Menus;

type
  TfmMain = class(TForm)
    Document: TXMLDocument;
    ImageList1: TImageList;
    ActionList1: TActionList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    SaveAs1: TMenuItem;
    Save1: TMenuItem;
    Open1: TMenuItem;
    New1: TMenuItem;
    Edit1: TMenuItem;
    Paste1: TMenuItem;
    Copy1: TMenuItem;
    Cut1: TMenuItem;
    Delete1: TMenuItem;
    FileOpen1: TFileOpen;
    FileSaveAs1: TFileSaveAs;
    FileExit1: TFileExit;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    EditDelete1: TEditDelete;
    tvXML: TTreeView;
    Splitter1: TSplitter;
    FileSave1: TAction;
    pcEdits: TPageControl;
    tsProps: TTabSheet;
    edValue: TEdit;
    laAttributes: TLabel;
    vleAttributes: TValueListEditor;
    tsXML: TTabSheet;
    meXML: TMemo;
    pmAttrEdit: TPopupMenu;
    Edit2: TMenuItem;
    Paste2: TMenuItem;
    Copy2: TMenuItem;
    Cut2: TMenuItem;
    N7: TMenuItem;
    N3: TMenuItem;
    DeleteAttr1: TMenuItem;
    AddAttr1: TMenuItem;
    pmNodes: TPopupMenu;
    AddChild: TMenuItem;
    DeleteEl: TMenuItem;
    AddSibling: TMenuItem;
    FileNew1: TAction;
    StatusBar1: TStatusBar;
    laText: TLabel;
    procedure tvXMLChange(Sender: TObject; Node: TTreeNode);
    procedure FileSave1Execute(Sender: TObject);
    procedure FileOpen1Accept(Sender: TObject);
    procedure tvXMLChanging(Sender: TObject; Node: TTreeNode;
      var AllowChange: Boolean);
    procedure AddAttr1Click(Sender: TObject);
    procedure DeleteAttr1Click(Sender: TObject);
    procedure AddChildClick(Sender: TObject);
    procedure tvXMLEdited(Sender: TObject; Node: TTreeNode; var S: String);
    procedure AddSiblingClick(Sender: TObject);
    procedure FileNew1Execute(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FileSaveAs1Accept(Sender: TObject);
    procedure EditDelete1Execute(Sender: TObject);
    procedure vleAttributesStringsChange(Sender: TObject);
    procedure edValueChange(Sender: TObject);
    procedure EditCut1Execute(Sender: TObject);
    procedure EditCopy1Execute(Sender: TObject);
    procedure EditPaste1Execute(Sender: TObject);
    procedure ActionList1Update(Action: TBasicAction;
      var Handled: Boolean);
  private
    { Private declarations }
    FDocumentName : string;
    FModified : Boolean;
    procedure SetModified( Value : boolean );
  public
    { Public declarations }
   function GetXMLNode( Node : TTreeNode ): IXMLNode;
   function XMLNodeToTreeViewNode( AXMLNode : IXMLNode; ParentNode : TTreeNode ): TTreeNode;
   procedure XMLDocToTreeView( Doc : IXMLDocument; TV : TTreeView );
   property Modified : boolean read FModified write SetModified;
   procedure ClearEdits;
  end;

var
  fmMain: TfmMain;

implementation

{$R *.dfm}
uses ClipBrd;

procedure TfmMain.FormCreate(Sender: TObject);
begin
 FDocumentName := '';
 Modified := False;
end;

procedure TfmMain.SetModified( Value : boolean );
const ModifiedText : array[False..True] of string = ( '','Modified');
begin
 if value <> FModified then
  begin
   FModified := value;
   Statusbar1.Panels[0].Text := ModifiedText[ FModified ];
  end;
end;

function TfmMain.GetXMLNode( Node : TTreeNode ): IXMLNode;
begin
 Result := nil;
 if not Document.Active
 or not Assigned( Node )
 or not Assigned( Node.Data )
  then Exit;
 try
  Result := IXMLNode( Node.Data );
 except
 end;
end;

procedure TfmMain.FileNew1Execute(Sender: TObject);
begin
 Document.XML.Clear;
 Document.Active := True;
 tvXML.Items.Clear;
 ClearEdits;
 FDocumentName := '';
 Modified := False;
end;

function TfmMain.XMLNodeToTreeViewNode( AXMLNode : IXMLNode; ParentNode : TTreeNode ): TTreeNode;
var i: Integer;
begin
 Result := nil;
 if not Assigned( AXMLNode ) then Exit;
 try
  Result := tvXML.Items.AddChild( ParentNode, AXMLNode.NodeName );
  Result.ImageIndex := Ord( AXMLNode.NodeType );
  Result.SelectedIndex := Result.ImageIndex;
  Result.Data := Pointer( AXMLNode );
  for i := 0 to AXMLNode.ChildNodes.Count - 1  do
   if AXMLNode.ChildNodes[i].NodeType <> ntText then //ignore text nodes
     XMLNodeToTreeViewNode( AXMLNode.ChildNodes[i], Result );
 except
 end;
end;

procedure TfmMain.XMLDocToTreeView( Doc : IXMLDocument; tv : TTreeView );
begin
  tv.Items.Clear;
  try
   Screen.Cursor := crHourGlass;
   XMLNodeToTreeViewNode( Doc.DocumentElement, nil );
  finally
   Screen.Cursor := crDefault;
  end;
end;

procedure TfmMain.FileOpen1Accept(Sender: TObject);
begin
 try
  Document.LoadFromFile( FileOpen1.Dialog.FileName );
  XMLDocToTreeView( Document, tvXML );
  FDocumentName := FileOpen1.Dialog.FileName;
  Modified := False;
 except
  on E:EDOMParseError do
   ShowMessage( 'Parser error. Message:'#13#10 + E.Reason );
 end;
end;

procedure TfmMain.FileSave1Execute(Sender: TObject);
begin
 if Document.Active
 and not Document.IsEmptyDoc then
  begin
   Document.SaveToFile( FDocumentName );
  end;
end;

procedure TfmMain.FileSaveAs1Accept(Sender: TObject);
begin
 FDocumentName := FileSaveAs1.Dialog.FileName;
 FileSave1Execute( Sender );
end;

procedure TfmMain.ClearEdits;
begin
  vleAttributes.Strings.Clear;
  edValue.Text := '';
  meXML.Lines.Clear;
end;

//update TreeNode with XMLNode
procedure TfmMain.tvXMLChange(Sender: TObject; Node: TTreeNode);
var i: Integer;
  AXMLNode : IXMLNode;
begin
  ClearEdits;
  AXMLNode := GetXMLNode( Node );
  if not Assigned( AXMLNode ) then Exit;
  try
    //show text
    if (AXMLNode.NodeType = ntElement)
    and not AXMLNode.IsTextElement then
      begin
      if AXMLNode.HasChildNodes
      and (AXMLNode.ChildNodes[0].NodeType = ntText) then
       edValue.Text := VarToStr( AXMLNode.ChildNodes[0].nodeValue )
      else
       edValue.Text := '';
      end
     else
      edValue.Text := VarToStr( AXMLNode.NodeValue );
    //show attributes
    for i := 0 to AXMLNode.AttributeNodes.Count -1 do
    vleAttributes.strings.Add(
     AXMLNode.AttributeNodes[i].NodeName
      + '=' + VarToStr(AXMLNode.AttributeNodes[i].NodeValue) );
    //show XML
    MeXML.Lines.Text := AXMLNode.XML;
    Modified := False;
  except
  end;
end;

//update XMLNode with TreeNode
procedure TfmMain.tvXMLChanging(Sender: TObject; Node: TTreeNode;
  var AllowChange: Boolean);
var
  AXMLNode : IXMLNode;

procedure UpdateAttributes( Node : TTreeNode );
var i: Integer;
begin
  AXMLNode := GetXMLNode( Node );
  if not Assigned( AXMLNode ) then Exit;
  try
   AXMLNode.GetAttributeNodes.Clear;
   if vleAttributes.Strings.Count=0 then Exit;
   for i := 1 to vleAttributes.RowCount - 1  do
    if vleAttributes.Keys[i]<>'' then
     AXMLNode.Attributes[ vleAttributes.Keys[i] ] :=
      vleAttributes.Values[ vleAttributes.Keys[i] ];
   except
   end;
end;

procedure UpdateValue( Node : TTreeNode );
begin
 AXMLNode := GetXMLNode( Node );
 if not Assigned( AXMLNode ) then Exit;
 if AXMLNode.IsTextElement then
   AXMLNode.Text := EdValue.Text
 else with AXMLNode do
  begin
   //text added at first
   if (not HasChildNodes) and (EdValue.Text<>'') then
     ChildNodes.Add( OwnerDocument.CreateNode( EdValue.Text, ntText ) )
   else
     begin
      //already has text
      if ChildNodes[0].NodeType = ntText then
        ChildNodes[0].NodeValue := EdValue.Text
      //has children but not text
      else if EdValue.Text<>'' then
        ChildNodes.Insert(0, OwnerDocument.CreateNode( EdValue.Text, ntText ) );
     end;
  end;
end;

begin
 if not Modified then  Exit;
 try
  UpdateValue( tvXML.Selected );
  UpdateAttributes( tvXML.Selected );
 except
  AllowChange := False;
 end;
end;

procedure TfmMain.AddAttr1Click(Sender: TObject);
begin
 vleAttributes.InsertRow('','', True );
end;

procedure TfmMain.DeleteAttr1Click(Sender: TObject);
begin
 vleAttributes.DeleteRow( vleAttributes.Row );
end;

procedure TfmMain.AddChildClick(Sender: TObject);
var 
 AXMLNode, ChildNode : IXMLNode;
 NodeName : string;
begin
 AXMLNode := GetXMLNode( tvXML.Selected );
 if Not Assigned( AXMLNode ) then Exit;

 if Not InputQuery( Application.Title, 'New node name', NodeName )
  or (NodeName = '') then Exit;

 ChildNode := AXMLNode.AddChild( NodeName );
 XMLNodeToTreeViewNode( ChildNode, tvXML.Selected );
end;

procedure TfmMain.AddSiblingClick(Sender: TObject);
var
 AXMLNode, SiblingNode : IXMLNode;
 NodeName : string;
begin
 AXMLNode := GetXMLNode( tvXML.Selected );
 if Not Assigned( AXMLNode ) then Exit;

 if Not InputQuery( Application.Title, 'New node name', NodeName )
  or (NodeName = '') then Exit;

 SiblingNode := AXMLNode.ParentNode.AddChild( NodeName );
 XMLNodeToTreeViewNode( SiblingNode, tvXML.Selected.Parent );
end;

 //copied from module XMLDoc
procedure CopyChildNodes(SrcNode, DestNode: IXMLNode);
var
  I: Integer;
  SrcChild, DestChild: IXMLNode;
begin
  for I := 0 to SrcNode.ChildNodes.Count - 1 do
  begin
    SrcChild := SrcNode.ChildNodes[I];
    DestChild := SrcChild.CloneNode(False);
    { Note this fails on documents with DOCTYPE nodes }
    DestNode.ChildNodes.Add(DestChild);
    if SrcChild.HasChildNodes then
      CopyChildNodes(SrcChild, DestChild);
  end;
end;

procedure TfmMain.tvXMLEdited(Sender: TObject; Node: TTreeNode;
  var S: String);
var AXMLNode, NewXMLNode : IXMLNode;
   ParentNode : TTreeNode;
begin
 if s = Node.Text then Exit
 else if s='' then //empty nodes disabled
  begin
   s := Node.Text;
   Exit;
  end;
 try
  AXMLNode := GetXMLNode( Node );
  if not Assigned( AXMLNode ) then Exit;
  NewXMLNode := AXMLNode.OwnerDocument.CreateElement( s, AXMLNode.NamespaceURI );
  CopyChildNodes( AXMLNode, NewXMLNode );
  AXMLNode := AXMLNode.ParentNode.ChildNodes.ReplaceNode( AXMLNode, NewXMLNode );
  AXMLNode := nil;
  ParentNode := Node.Parent;
  Node.Delete;
  tvXML.Selected := XMLNodeToTreeViewNode( NewXMLNode, ParentNode );
 except
 end;
end;

procedure TfmMain.vleAttributesStringsChange(Sender: TObject);
begin
 Modified := True;
end;

procedure TfmMain.edValueChange(Sender: TObject);
begin
 Modified := True;
end;

procedure TfmMain.EditDelete1Execute(Sender: TObject);
var AXMLNode : IXMLNode;
begin
 try
  AXMLNode := GetXMLNode( tvXML.Selected );
  if Not Assigned( AXMLNode ) then Exit;
  AXMLNode.ParentNode.ChildNodes.Remove( AXMLNode );
  tvXML.Selected.Delete;
  if Not Assigned( tvXML.Selected ) then ClearEdits;
 except
 end;
end;

procedure TfmMain.EditCopy1Execute(Sender: TObject);
begin
 try
  Clipboard.AsText := GetXMLNode( tvXML.Selected ).XML;
 except
 end;
end;

procedure TfmMain.EditCut1Execute(Sender: TObject);
begin
  EditCopy1Execute( Sender );
  EditDelete1Execute( Sender );
end;

procedure TfmMain.EditPaste1Execute(Sender: TObject);
var NewDoc : IXMLDocument;
  AXMLNode, NewNode : IXMLNode;
begin
 if not Clipboard.HasFormat( CF_TEXT ) then Exit;
 try
  try
   NewDoc := LoadXMLData( Clipboard.AsText );
  except
   on E:EDOMParseError do
    ShowMessage( 'Parser error. Message:'#13#10 + E.Reason );
  end;
  if not Assigned( NewDoc ) then Exit;
  //for new( empty ) document
  if tvXML.Items.Count=0 then
   begin
    try
     Document.LoadFromXML( NewDoc.XML.Text );
     XMLDocToTreeView( Document, tvXML );
     FDocumentName := '';
    except
     on E:EDOMParseError do
      ShowMessage( 'Parser error. Message:'#13#10 + E.Reason );
    end;
    Exit;
   end;
  AXMLNode := GetXMLNode( tvXML.Selected );
  if Not Assigned( AXMLNode ) then Exit;

  NewNode := NewDoc.DocumentElement.CloneNode( True );
  AXMLNode.ChildNodes.Add( NewNode );
  XMLNodeToTreeViewNode( NewNode, tvXML.Selected );
 finally
  NewDoc := nil;
 end;
end;

procedure TfmMain.ActionList1Update(Action: TBasicAction;
  var Handled: Boolean);
begin
 EditCopy1.Enabled := Document.Active and Assigned( tvXML.Selected );
 EditCut1.Enabled := EditCopy1.Enabled;
 EditDelete1.Enabled := EditCopy1.Enabled;
 EditPaste1.Enabled := Clipboard.HasFormat( CF_TEXT );
end;

end.
