unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, xmldom, XMLIntf, msxmldom, XMLDoc, StdCtrls, ComCtrls, ImgList,
  ExtCtrls;

type
  TForm1 = class(TForm)
    XMLDocument1: TXMLDocument;
    OpenDialog1: TOpenDialog;
    tvXML: TTreeView;
    ImageList1: TImageList;
    Panel1: TPanel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}


procedure TForm1.Button1Click(Sender: TObject);

function DOMNode2TreeViewNode( ADOMNode : IDOMNode; ParentNode : TTreeNode ):boolean;
var i: Integer;
    ThisNode : TTreeNode;
    TVNodes : TTreeNodes;
begin
 if not Assigned( ADOMNode ) then Exit;
 TVNodes := tvXML.items;
 ThisNode := TVNodes.AddChild( ParentNode, ADOMNode.NodeName );
 if not Assigned( ThisNode ) then Abort;
 ThisNode.ImageIndex := 0;
 if Assigned( ADOMNode.attributes ) then
  for i := 0 to ADOMNode.attributes.length -1  do
   with TVNodes.AddChild( ThisNode, ADOMNode.Attributes.item[i].NodeName ) do
    begin
     ImageIndex := 1;
     SelectedIndex := ImageIndex;
    end;
 ThisNode.SelectedIndex := ThisNode.ImageIndex;
 if Assigned( ADOMNode.ChildNodes ) then
  for i := 0 to ADOMNode.ChildNodes.length -1  do
   DOMNode2TreeViewNode( ADOMNode.ChildNodes[i], ThisNode );
end;

begin
 if not OpenDialog1.Execute then Exit;
 try
  XMLDocument1.LoadFromFile( OpenDialog1.FileName );
  tvXML.Items.Clear;
  try
   Screen.Cursor := crHourGlass;
   DOMNode2TreeViewNode( XMLDocument1.DOMDocument, nil );
  finally
   Screen.Cursor := crDefault;
  end;
 except
  on E:EDOMParseError do
   begin
    ShowMessage( 'Parser error. Message:'#13#10 + E.Reason );
   end;
 end;
end;

end.
