unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, ComCtrls, Menus, ToolWin, ImgList;

type
  TfmMain = class(TForm)
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    tcStores: TTabControl;
    PopupMenu1: TPopupMenu;
    miProperties: TMenuItem;
    ToolBar1: TToolBar;
    tbImport: TToolButton;
    tbExport: TToolButton;
    tbDelete: TToolButton;
    tbInfo: TToolButton;
    lvCerts: TListView;
    ImageList1: TImageList;
    procedure tcStoresChange(Sender: TObject);
    procedure miPropertiesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure tbImportClick(Sender: TObject);
    procedure tbExportClick(Sender: TObject);
    procedure tbDeleteClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation
{$R *.DFM}
uses CertUtils;

function SysErrorInfo( Res: Integer ): string;
begin
 Result := SysErrorMessage( Res );
 if Result = '' then
  Result := Format('Unknown error 0x%x',[res]);
end;

procedure TfmMain.FormCreate(Sender: TObject);
var bEnum : boolean;
 s: string;
 i : Integer;
begin
 bEnum := False;
 if Win32Platform = 2 then
  begin
   if Win32MajorVersion >= 5 then bEnum := True
   else if Win32MajorVersion = 4 then
    begin
     i := Pos('Service Pack', Win32CSDVersion );
     if i>=0 then
      begin
       s := Copy( Win32CSDVersion, i, Length(Win32CSDVersion) );
       i := StrToIntDef( Trim(s), -1 );
       bEnum := i>=4;
      end;
    end;
   end;
  if bEnum then
    ListSystemStores( tcStores.Tabs );
 tcStoresChange(Sender);
end;

procedure TfmMain.tcStoresChange(Sender: TObject);
var sl : TStringList;
  i,j : Integer;
begin
 for i := 0 to lvCerts.Items.Count - 1 do
   if Assigned( lvCerts.Items[i].Data ) then
    FreeCertID( lvCerts.Items[i].Data );

 lvCerts.Items.Clear;

 Screen.Cursor := crHourglass;
 try
  sl := TStringList.Create;
  ListCerts( tcStores.Tabs[ tcStores.TabIndex ], sl );
  if sl.Count>0 then
   begin
    lvCerts.Items.BeginUpdate;
    for i := 0 to sl.Count - 1 do
     with lvCerts.Items.Add do
      begin
       SubItems.CommaText := sl[i];
       Caption := SubItems[0];
       SubItems.Delete( 0 );
       Data := Pointer( sl.Objects[i] );
      end;
     lvCerts.Items.EndUpdate;
   end;
 finally
  Screen.Cursor := crDefault;
  sl.Free;
 end;
end;


procedure TfmMain.miPropertiesClick(Sender: TObject);
var sl: TstringList; i : Integer;
begin
 if lvCerts.ItemIndex<0 then Exit;
 sl := TStringList.Create;
 try
  if Assigned(lvCerts.Items[lvCerts.ItemIndex].Data) then
   begin
    i := GetCertificateInfo( tcStores.Tabs[ tcStores.TabIndex ],
    lvCerts.Items[lvCerts.ItemIndex].Data, sl );
    if i=0 then
     ShowMessage( sl.Text )
    else
     begin
      i := GetCertificateInfo( tcStores.Tabs[ tcStores.TabIndex ],
       lvCerts.Items[lvCerts.ItemIndex].Caption, sl );
      if i=0 then
       ShowMessage( sl.Text )
      else
       ShowMessage( SysErrorInfo(i) );
     end;
   end;
 finally
  sl.Free;
 end;
end;

procedure TfmMain.tbImportClick(Sender: TObject);
var res: Integer;
begin
 if not OpenDialog1.Execute then Exit;
 res := InstallCert( pChar(OpenDialog1.Filename), pChar(tcStores.Tabs[ tcStores.TabIndex ]) );
 if res = 0 then
   ShowMessage( 'Pomylnie zainstalowano certyfikat' )
 else
   ShowMessage('Certyfikat nie zosta zainstalowany: '+SysErrorInfo(res) );
end;

procedure TfmMain.tbExportClick(Sender: TObject);
var res : Integer;
begin
 if not SaveDialog1.Execute then Exit;
 res := -1;
 if Assigned(lvCerts.Items[lvCerts.ItemIndex].Data) then
 res := ExportCert(  tcStores.Tabs[ tcStores.TabIndex ],
                     lvCerts.Items[lvCerts.ItemIndex].Data,
                     SaveDialog1.FileName );
 if res = 0 then
   ShowMessage( 'Pomylnie wyeksportowano certyfikat' )
 else
   ShowMessage( 'Certyfikat nie zosta wyeksportowany: '+SysErrorInfo(res) );
end;

procedure TfmMain.tbDeleteClick(Sender: TObject);
var res: Integer; s: string;
begin
 if lvCerts.ItemIndex<0 then Exit;
 res := -1;
 if Assigned(lvCerts.Items[lvCerts.ItemIndex].Data) then
 Res := DeleteCert( tcStores.Tabs[ tcStores.TabIndex ],
  lvCerts.Items[lvCerts.ItemIndex].Data );
 if Res=0 then
  begin
   FreeCertID( lvCerts.Items[lvCerts.ItemIndex].Data );
   s := lvCerts.Items[lvCerts.ItemIndex].Caption;
   lvCerts.Items[lvCerts.ItemIndex].Delete;
   ShowMessage('Pomylnie usunito certyfikat ' + s );
  end
 else
   ShowMessage('Certyfikat nie zosta usunity: '+SysErrorInfo(res) );
end;

end.
