unit uDMTest2;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComServ, ComObj, VCLCom, StdVcl, bdemts, DataBkr, DBClient,
  MtsRdm, Mtx, MTSServer2_TLB, DB, ADODB;

type
  TDMTest2 = class(TMtsDataModule, IDMTest2)
    conDBDemos: TADOConnection;
    quCustCount: TADOQuery;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    procedure GetCustCount(out CustCount: Integer); safecall;
  public
    { Public declarations }
  end;

var
  DMTest2: TDMTest2;

implementation

{$R *.DFM}

const DefCustCount: Integer = -1;

class procedure TDMTest2.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TDMTest2.GetCustCount(out CustCount: Integer);
begin
 try
  conDBDemos.Open;
  try
   quCustCount.Open;
   CustCount := quCustCount.Fields[0].AsInteger;
   quCustCount.Close;
  finally
   conDBDemos.Close;
  end;
  SetComplete;
 except
  CustCount := DefCustCount;
  SetAbort;
 end;
end;

initialization
  TComponentFactory.Create(ComServer, TDMTest2,
    Class_DMTest2, ciMultiInstance, tmBoth);
end.