unit cliUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, StdCtrls, Buttons, ScktComp, ExtCtrls, ComCtrls;

type
  TClientForm = class(TForm)
    Bevel1: TBevel;
    ClientSocket: TClientSocket;
    TimeSpeedButton: TSpeedButton;
    MemSpeedButton: TSpeedButton;
    procedure Disconnect1Click(Sender: TObject);
    procedure ClientSocketRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure ClientSocketError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure MemSpeedButtonClick(Sender: TObject);
    procedure TimeSpeedButtonClick(Sender: TObject);
   public
    procedure ConnectToServer;
  end;

var
  ClientForm: TClientForm;

implementation

{$R *.DFM}


procedure TClientForm.ConnectToServer;
var sAddr: string;
begin
  if ClientSocket.Active then ClientSocket.Active := False;
  try
   if not InputQuery('Wybierz host', 'Adres hosta', sAddr) then Abort;
   if Length(sAddr) = 0 then Abort;
   with ClientSocket do
    begin
     Host := sAddr;
     Active := True;
    end;
  except
    TimeSpeedButton.Down := False;
    MemSpeedButton.Down := False;
  end;
end;

procedure TClientForm.Disconnect1Click(Sender: TObject);
begin
  TimeSpeedButton.Down := False;
  MemSpeedButton.Down := False;
  ClientSocket.Close;
end;

procedure TClientForm.ClientSocketRead(Sender: TObject;
  Socket: TCustomWinSocket);
  var s,s1: string;  p : pChar;
begin
  s:= Socket.ReceiveText;
  if TimeSpeedButton.Down then
   begin
    p := AnsiStrRScan(pChar(s),'T');
    if p<>nil then
     begin
      TimeSpeedButton.Caption := Copy(string(p),2, 8);
     end;
   end;
   if MemSpeedButton.Down then
   begin
    p := AnsiStrRScan(pChar(s),'M');
    if p<>nil then
     begin
      MemSpeedButton.Caption := Copy(string(p), 2, 11);
     end;
   end;
end;


procedure TClientForm.ClientSocketError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin
  Application.MessageBox(pChar(Format('Bd podczas czenia si z %s:'#13#10'%s',
   [ClientSocket.Host, SysErrorMessage( ErrorCode ) ])),
  pChar(Application.Title),
  MB_ICONERROR or MB_Ok);
  ErrorCode := 0;
  MemSpeedButton.Down := False;
  TimeSpeedButton.Down := False;
end;

procedure TClientForm.MemSpeedButtonClick(Sender: TObject);
begin
 if MemSpeedButton.Down then
  begin if not ClientSocket.Active then ConnectToServer; end
 else
  begin
   if not TimeSpeedButton.Down then ClientSocket.Active := False;
   MemSpeedButton.Caption := 'Pami';
  end;
end;

procedure TClientForm.TimeSpeedButtonClick(Sender: TObject);
begin
 if TimeSpeedButton.Down then
  begin if not ClientSocket.Active then ConnectToServer; end
 else
  begin
   if not MemSpeedButton.Down then ClientSocket.Active := False;
   TimeSpeedButton.Caption := 'Czas';
  end;
end;

end.
