unit uSecondary;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, SimpleAppSrvr_TLB, StdVcl, DB, IBCustomDataSet, IBQuery,
  IBDatabase, IBTable, Provider, ADODB;

type
  TSecondary = class(TRemoteDataModule, ISecondary)
    dspVendors: TDataSetProvider;
    dspParts: TDataSetProvider;
    conMastApp: TADOConnection;
    tblVendors: TADOTable;
    tblParts: TADOTable;
    dsVendors: TDataSource;
    procedure conMastAppBeforeConnect(Sender: TObject);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

var
  FSecondaryFactory: TComponentFactory;

implementation

uses uSimpleAppSrvr;

{$R *.DFM}

class procedure TSecondary.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

procedure TSecondary.conMastAppBeforeConnect(Sender: TObject);
begin
 if fmMain.edDataPath.Text <> ''
  then conMastApp.ConnectionString := 'Provider=Microsoft.Jet.OLEDB.4.0;Persist Security Info=False;Data Source=' + fmMain.edDataPath.Text
  else Abort;
end;

initialization
  FSecondaryFactory := TComponentFactory.Create(ComServer, TSecondary,
    Class_Secondary, ciMultiInstance, tmApartment);
end.
