unit PenXImpl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ActiveX, AxCtrls, PenXProj_TLB, ComCtrls, StdCtrls, StdVcl;

type
  TPenX = class(TActiveForm, IPenX)
    ClrComboBox: TComboBox;
    StyleComboBox: TComboBox;
    WidthTrackBar: TTrackBar;
    procedure ClrComboBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure StyleComboBoxDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure ComboBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WidthTrackBarChange(Sender: TObject);
  private
    { Private declarations }
    FEvents: IPenXEvents;
    procedure ActivateEvent(Sender: TObject);
    procedure ClickEvent(Sender: TObject);
    procedure CreateEvent(Sender: TObject);
    procedure DblClickEvent(Sender: TObject);
    procedure DeactivateEvent(Sender: TObject);
    procedure DestroyEvent(Sender: TObject);
    procedure KeyPressEvent(Sender: TObject; var Key: Char);
    procedure PaintEvent(Sender: TObject);
  protected
    { Protected declarations }
    procedure DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage); override;
    procedure EventSinkChanged(const EventSink: IUnknown); override;
    function Get_Active: WordBool; safecall;
    function Get_AutoScroll: WordBool; safecall;
    function Get_AutoSize: WordBool; safecall;
    function Get_AxBorderStyle: TxActiveFormBorderStyle; safecall;
    function Get_BiDiMode: TxBiDiMode; safecall;
    function Get_Caption: WideString; safecall;
    function Get_Color: OLE_COLOR; safecall;
    function Get_Cursor: Smallint; safecall;
    function Get_DoubleBuffered: WordBool; safecall;
    function Get_DropTarget: WordBool; safecall;
    function Get_Enabled: WordBool; safecall;
    function Get_Font: IFontDisp; safecall;
    function Get_HelpFile: WideString; safecall;
    function Get_KeyPreview: WordBool; safecall;
    function Get_PixelsPerInch: Integer; safecall;
    function Get_PrintScale: TxPrintScale; safecall;
    function Get_Scaled: WordBool; safecall;
    function Get_Visible: WordBool; safecall;
    procedure _Set_Font(const Value: IFontDisp); safecall;
    procedure AboutBox; safecall;
    procedure Set_AutoScroll(Value: WordBool); safecall;
    procedure Set_AutoSize(Value: WordBool); safecall;
    procedure Set_AxBorderStyle(Value: TxActiveFormBorderStyle); safecall;
    procedure Set_BiDiMode(Value: TxBiDiMode); safecall;
    procedure Set_Caption(const Value: WideString); safecall;
    procedure Set_Color(Value: OLE_COLOR); safecall;
    procedure Set_Cursor(Value: Smallint); safecall;
    procedure Set_DoubleBuffered(Value: WordBool); safecall;
    procedure Set_DropTarget(Value: WordBool); safecall;
    procedure Set_Enabled(Value: WordBool); safecall;
    procedure Set_Font(var Value: IFontDisp); safecall;
    procedure Set_HelpFile(const Value: WideString); safecall;
    procedure Set_KeyPreview(Value: WordBool); safecall;
    procedure Set_PixelsPerInch(Value: Integer); safecall;
    procedure Set_PrintScale(Value: TxPrintScale); safecall;
    procedure Set_Scaled(Value: WordBool); safecall;
    procedure Set_Visible(Value: WordBool); safecall;
    function Get_PenColor: Integer; safecall;
    function Get_PenStyle: Integer; safecall;
    function Get_PenWidth: Integer; safecall;
    procedure Set_PenColor(Value: Integer); safecall;
    procedure Set_PenStyle(Value: Integer); safecall;
    procedure Set_PenWidth(Value: Integer); safecall;  procedure IPenX._Set_Font = IPenX__Set_Font;
    procedure IPenX.Set_Font = IPenX_Set_Font;
  
    procedure IPenX__Set_Font(var Value: IFontDisp); safecall;
    procedure IPenX_Set_Font(const Value: IFontDisp); safecall;
  public
    { Public declarations }
    procedure Initialize; override;
  end;

implementation

uses ComObj, ComServ, PenXAboutUnit;

{$R *.DFM}

{ TPenX }

procedure TPenX.DefinePropertyPages(DefinePropertyPage: TDefinePropertyPage);
begin
  { Define property pages here.  Property pages are defined by calling
    DefinePropertyPage with the class id of the page.  For example,
      DefinePropertyPage(Class_PenXPage); }
end;

procedure TPenX.EventSinkChanged(const EventSink: IUnknown);
begin
  FEvents := EventSink as IPenXEvents;
end;

procedure TPenX.Initialize;
begin
  inherited Initialize;
  OnActivate := ActivateEvent;
  OnClick := ClickEvent;
  OnCreate := CreateEvent;
  OnDblClick := DblClickEvent;
  OnDeactivate := DeactivateEvent;
  OnDestroy := DestroyEvent;
  OnKeyPress := KeyPressEvent;
  OnPaint := PaintEvent;
end;

function TPenX.Get_Active: WordBool;
begin
  Result := Active;
end;

function TPenX.Get_AutoScroll: WordBool;
begin
  Result := AutoScroll;
end;

function TPenX.Get_AutoSize: WordBool;
begin
  Result := AutoSize;
end;

function TPenX.Get_AxBorderStyle: TxActiveFormBorderStyle;
begin
  Result := Ord(AxBorderStyle);
end;

function TPenX.Get_BiDiMode: TxBiDiMode;
begin
  Result := Ord(BiDiMode);
end;

function TPenX.Get_Caption: WideString;
begin
  Result := WideString(Caption);
end;

function TPenX.Get_Color: OLE_COLOR;
begin
  Result := OLE_COLOR(Color);
end;

function TPenX.Get_Cursor: Smallint;
begin
  Result := Smallint(Cursor);
end;

function TPenX.Get_DoubleBuffered: WordBool;
begin
  Result := DoubleBuffered;
end;

function TPenX.Get_DropTarget: WordBool;
begin
  Result := DropTarget;
end;

function TPenX.Get_Enabled: WordBool;
begin
  Result := Enabled;
end;

function TPenX.Get_Font: IFontDisp;
begin
  GetOleFont(Font, Result);
end;

function TPenX.Get_HelpFile: WideString;
begin
  Result := WideString(HelpFile);
end;

function TPenX.Get_KeyPreview: WordBool;
begin
  Result := KeyPreview;
end;

function TPenX.Get_PixelsPerInch: Integer;
begin
  Result := PixelsPerInch;
end;

function TPenX.Get_PrintScale: TxPrintScale;
begin
  Result := Ord(PrintScale);
end;

function TPenX.Get_Scaled: WordBool;
begin
  Result := Scaled;
end;

function TPenX.Get_Visible: WordBool;
begin
  Result := Visible;
end;

procedure TPenX._Set_Font(const Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TPenX.AboutBox;
begin
  ShowPenXAbout;
end;

procedure TPenX.Set_AutoScroll(Value: WordBool);
begin
  AutoScroll := Value;
end;

procedure TPenX.Set_AutoSize(Value: WordBool);
begin
  AutoSize := Value;
end;

procedure TPenX.Set_AxBorderStyle(Value: TxActiveFormBorderStyle);
begin
  AxBorderStyle := TActiveFormBorderStyle(Value);
end;

procedure TPenX.Set_BiDiMode(Value: TxBiDiMode);
begin
  BiDiMode := TBiDiMode(Value);
end;

procedure TPenX.Set_Caption(const Value: WideString);
begin
  Caption := TCaption(Value);
end;

procedure TPenX.Set_Color(Value: OLE_COLOR);
begin
  Color := TColor(Value);
end;

procedure TPenX.Set_Cursor(Value: Smallint);
begin
  Cursor := TCursor(Value);
end;

procedure TPenX.Set_DoubleBuffered(Value: WordBool);
begin
  DoubleBuffered := Value;
end;

procedure TPenX.Set_DropTarget(Value: WordBool);
begin
  DropTarget := Value;
end;

procedure TPenX.Set_Enabled(Value: WordBool);
begin
  Enabled := Value;
end;

procedure TPenX.Set_Font(var Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TPenX.Set_HelpFile(const Value: WideString);
begin
  HelpFile := String(Value);
end;

procedure TPenX.Set_KeyPreview(Value: WordBool);
begin
  KeyPreview := Value;
end;

procedure TPenX.Set_PixelsPerInch(Value: Integer);
begin
  PixelsPerInch := Value;
end;

procedure TPenX.Set_PrintScale(Value: TxPrintScale);
begin
  PrintScale := TPrintScale(Value);
end;

procedure TPenX.Set_Scaled(Value: WordBool);
begin
  Scaled := Value;
end;

procedure TPenX.Set_Visible(Value: WordBool);
begin
  Visible := Value;
end;

procedure TPenX.ActivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnActivate;
end;

procedure TPenX.ClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnClick;
end;

procedure TPenX.CreateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnCreate;
end;

procedure TPenX.DblClickEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDblClick;
end;

procedure TPenX.DeactivateEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDeactivate;
end;

procedure TPenX.DestroyEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnDestroy;
end;

procedure TPenX.KeyPressEvent(Sender: TObject; var Key: Char);
var
  TempKey: Smallint;
begin
  TempKey := Smallint(Key);
  if FEvents <> nil then FEvents.OnKeyPress(TempKey);
  Key := Char(TempKey);
end;

procedure TPenX.PaintEvent(Sender: TObject);
begin
  if FEvents <> nil then FEvents.OnPaint;
end;

const DefColors : array [0..15] of TColor =( clBlack,
  clMaroon, clGreen, clOlive, clNavy, clPurple, clTeal, clGray, clSilver,
  clRed, clLime, clYellow, clBlue, clFuchsia, clAqua,
  clWhite);

procedure TPenX.ClrComboBoxDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
begin
 with ClrComboBox.Canvas do
 begin
  Brush.Color := DefColors[Index];
  FillRect(Rect);
 end;
end;

procedure TPenX.StyleComboBoxDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var FPos : Integer;
begin
 FPos := Rect.Top + (Rect.Bottom - Rect.Top) div 2;
 with StyleComboBox.Canvas do
 begin
  Brush.Color := clWhite;
  FillRect(Rect);
  Pen.Style := TPenStyle(Index);
  Pen.Width := WidthTrackBar.Position;
  MoveTo(Rect.Left, FPos);
  LineTo(Rect.Right, FPos);
 end;
end;

function TPenX.Get_PenColor: Integer;
begin
 Result := DefColors[ClrComboBox.ItemIndex];
end;

function TPenX.Get_PenStyle: Integer;
begin
 Result := StyleComboBox.ItemIndex;
end;

function TPenX.Get_PenWidth: Integer;
begin
 Result := WidthTrackBar.Position;
end;

procedure TPenX.Set_PenColor(Value: Integer);
begin
 if Value in [Low(DefColors)..High(DefColors)] then
 ClrComboBox.ItemIndex := Value;
 ComboBoxChange(ClrComboBox);
end;

procedure TPenX.Set_PenStyle(Value: Integer);
begin
 if TPenStyle(Value) in [Low(TPenStyle)..High(TPenStyle)] then
 StyleComboBox.ItemIndex := Value;
 ComboBoxChange(StyleComboBox);
end;

procedure TPenX.Set_PenWidth(Value: Integer);
begin
 if Value in [1..8] then
  begin
   WidthTrackBar.Position := Value;
   ComboBoxChange(StyleComboBox);
  end;
end;

procedure TPenX.FormCreate(Sender: TObject);
var i: Integer;
begin
 for i := Low(DefColors) to High(DefColors) do
  ClrComboBox.Items.Add(IntToStr(i) );
 ClrComboBox.ItemIndex := 0;

 for i := 0 to 7 do
  StyleComboBox.Items.Add(IntToStr(i) );
 StyleComboBox.ItemIndex := 0;
end;

procedure TPenX.ComboBoxChange(Sender: TObject);
begin
 (Sender as TWinControl).Repaint;
 if FEvents<>nil then FEvents.OnPenChanged;
end;

procedure TPenX.WidthTrackBarChange(Sender: TObject);
begin
 if WidthTrackBar.Position>1 then StyleComboBox.ItemIndex:=0;
 ComboBoxChange(StyleComboBox);
end;

procedure TPenX.IPenX__Set_Font(var Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

procedure TPenX.IPenX_Set_Font(const Value: IFontDisp);
begin
  SetOleFont(Font, Value);
end;

initialization
  TActiveFormFactory.Create(
    ComServer,
    TActiveFormControl,
    TPenX,
    Class_PenX,
    1,
    '',
    OLEMISC_SIMPLEFRAME or OLEMISC_ACTSLIKELABEL,
    tmApartment);

end.
