unit uMain;

interface

uses
  Windows, SysUtils, Classes, HTTPApp, HTTPProd, DSProd, DB, ADODB, DBWeb;

type
  TwmMain = class(TWebModule)
    MainPage: TPageProducer;
    CountryList: TDataSetPageProducer;
    Country: TADOTable;
    CountryTable: TDataSetTableProducer;
    procedure MainPageHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure CountryListHTMLTag(Sender: TObject; Tag: TTag;
      const TagString: String; TagParams: TStrings;
      var ReplaceText: String);
    procedure CountryTableFormatCell(Sender: TObject; CellRow,
      CellColumn: Integer; var BgColor: THTMLBgColor;
      var Align: THTMLAlign; var VAlign: THTMLVAlign; var CustomAttrs,
      CellData: String);
    procedure WebModuleCreate(Sender: TObject);
  private
    FilePath: array[0..MAX_PATH - 1] of char;
    WebAppName: String;
  public
    { Public declarations }
  end;

var
  wmMain: TwmMain;

implementation

uses WebReq, dialogs;

{$R *.DFM}

procedure TwmMain.WebModuleCreate(Sender: TObject);
begin
 SetString(WebAppName, FilePath, GetModuleFileName(hInstance, FilePath, SizeOf(FilePath)));
 WebAppName := ExtractFileName(WebAppName);
end;

procedure TwmMain.MainPageHTMLTag(Sender: TObject; Tag: TTag;
  const TagString: String; TagParams: TStrings; var ReplaceText: String);
begin
 if TagString = 'APPNAME' then
   ReplaceText := WebAppName;
end;

procedure TwmMain.CountryListHTMLTag(Sender: TObject; Tag: TTag; const TagString: String; TagParams: TStrings; var ReplaceText: String);
var ResponseStr: String;
begin
 if TagString = 'COUNTRYLIST' then
 try
  Country.Open;
  try
   while not Country.EOF do
   begin
    ResponseStr := ResponseStr + Format('<TABLE><TD WIDTH=280>%s</TD>' +
                                               '<TD WIDTH=280>%s</TD>' +
                                               '<TD WIDTH=280>%s</TD></TABLE>',
     [Country.FieldByName('Name').AsString,
      Country.FieldByName('Capital').AsString,
      Country.FieldByName('Area').AsString]);
    Country.Next;
   end;
  finally
   Country.Close;
  end;
 except
  on E: Exception do ResponseStr := E.Message;
 end;
 ReplaceText := ResponseStr;
end;

procedure TwmMain.CountryTableFormatCell(Sender: TObject; CellRow,
  CellColumn: Integer; var BgColor: THTMLBgColor; var Align: THTMLAlign;
  var VAlign: THTMLVAlign; var CustomAttrs, CellData: String);
begin
 if CellRow = 0
  then BgColor := 'Gray'
   else
    if CellRow mod 2 = 0
     then BgColor := 'Silver';
end;

initialization
  if WebRequestHandler <> nil then
    WebRequestHandler.WebModuleClass := TwmMain;

end.
