unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, DB, ADODB, Grids, DBGrids;

type
  TfmMain = class(TForm)
    ADODataSet1: TADODataSet;
    Memo1: TMemo;
    btnToXML: TButton;
    ADOConnection1: TADOConnection;
    cbTables: TComboBox;
    btnFromXML: TButton;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    procedure btnToXMLClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnFromXMLClick(Sender: TObject);
    procedure cbTablesChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.dfm}
 uses ComObj, ActiveX, ADOInt, MSXML;

procedure TfmMain.FormCreate(Sender: TObject);
begin
 AdoConnection1.Connected := True;
 AdoConnection1.GetTableNames( cbTables.Items );
 cbTables.ItemIndex := 0;
 ADODataSet1.CommandText := cbTables.Text;
 ADODataSet1.Active := True;
end;

const
 SParserError =
  'Parser error. Message: %s'#13#10'URL: %s; src : %s;'#13#10'Line: %d, LinePos: %d';

procedure TfmMain.btnToXMLClick(Sender: TObject);
var
// i : Integer;
 rs : OleVariant;
 Doc : IXMLDOMDocument;
begin
 try
  Doc := CreateCOMObject( CLASS_DOMDocument ) as IXMLDOMDocument;
 try
  rs := ADODataSet1.Recordset;
  rs.Save( Doc, adPersistXML );
  if Doc.parseError.errorCode <> 0 then
   with Doc.parseError do
    begin
     Memo1.Lines.Clear;
     ShowMessage( Format( SParserError,
     [Reason, URL, srcText, Line, LinePos ]
     ) );
    end
  else
   Memo1.Text := Doc.xml ;
 finally
  rs := UnAssigned;
  Doc := nil;
 end;
 except
  on E:Exception do
    ShowMessage( E.ClassName + #13#10 + E.Message );
 end;
end;

procedure TfmMain.btnFromXMLClick(Sender: TObject);
var
// i : Integer;
 rs : _Recordset;
 Doc : IXMLDOMDocument;
begin
 try
  try
  Doc := CreateCOMObject( CLASS_DOMDocument ) as IXMLDOMDocument;
  if not Doc.loadXML( Memo1.Text ) then
   with Doc.parseError do
    begin
     Memo1.Lines.Clear;
     ShowMessage( Format(  SParserError,
     [Reason, URL, srcText, Line, LinePos ]
     ) );
     Exit;
    end;
  rs := CreateCOMObject( CLASS_Recordset ) as _Recordset;
  rs.Open( Doc, EmptyParam,  adOpenUnspecified, adLockUnspecified, adCmdFile );
  ADODataSet1.Recordset := rs;
 except
  on E:Exception do
    ShowMessage( E.ClassName + #13#10 + E.Message );
 end;
 finally
  rs := nil;
  Doc := nil;
 end;
end;

procedure TfmMain.cbTablesChange(Sender: TObject);
begin
 ADODataSet1.Active := False;
 ADODataSet1.CommandText := cbTables.Text;
 ADODataSet1.Active := True;
end;

end.
