unit CertUtils;

interface

uses SysUtils, Classes;

function InstallCert( const Store, FileName: string ): Integer;
function ExportCert( const Store, CertName, FileName: string ): Integer; overload;
function ExportCert( const Store: string; CertID: Pointer; FileName: string ): Integer; overload;
function DeleteCert( const StoreName, CertName : string ): Integer; overload;
function DeleteCert( const StoreName : string; CertID: Pointer ): Integer; overload;

Procedure FreeCertID( AnID : Pointer );
function ListCerts( StoreName: string; List : TStrings ): boolean;

function GetCertificateInfo( StoreName, CertName: string; InfoList : TStrings ): Integer; overload;
function GetCertificateInfo( StoreName : string; CertID: Pointer; InfoList : TStrings ): Integer; overload;

function ListSystemStores( List : TStrings ): boolean;


implementation


uses Windows, SysConst, WinCrypt;
{$DEFINE UNICODE}

function InstallCert( const Store, FileName: string ): Integer;
var CertFile: file;
    hStore : HCERTSTORE;
    PKCS7Length: Integer;
    Buf:pointer;
    p, pCertCon :PCCERT_CONTEXT;
    le : Integer;
    Res : boolean;
    ws : array[0..1023] of char;
    var i: Integer;
begin
 Result := -1;
 try
  try
   AssignFile( CertFile, FileName );
   ReSet( CertFile, 1 );
   PKCS7Length := FileSize( CertFile );
   buf := AllocMem( PKCS7Length );
   if not Assigned( buf ) then Abort;
   {$I-}
   blockread( CertFile, buf^, PKCS7Length, le );
   if PKCS7Length<>le then RaiseLastOSError;
     hStore := CertOpenSystemStore( 0, pChar(Store) );
   if not Assigned( hStore ) then RaiseLastOSError;
   pCertCon := CertCreateCertificateContext( X509_ASN_ENCODING or PKCS_7_ASN_ENCODING,
                                      buf, PKCS7Length );
   if not Assigned( pCertCon ) then RaiseLastOSError;
   i := CertGetNameString( pCertCon,
   CERT_NAME_SIMPLE_DISPLAY_TYPE,
   0,
   nil,
   @ws,
   512);
   {}
   p := CertFindCertificateInStore( hStore, X509_ASN_ENCODING or PKCS_7_ASN_ENCODING, 0,
   CERT_FIND_EXISTING, pCertCon, nil );
   if Assigned( p ) then
    begin
     CertFreeCertificateContext( p );
     Result := 0;
     Exit;
    end;
   Res := CertAddCertificateContextToStore(hStore,
                                      pCertCon,
                                      CERT_STORE_ADD_NEW,
                                      @p  );
   le := GetLastError;
   if (Res = False) and (DWORD(le)=$80092005)(*CRYPT_E_EXISTS*) then
    Result := 0
   else
    raise EOSError.CreateResFmt( @SOSError, [le, SysErrorMessage(le) ] )

  finally
   if Assigned( Buf ) then FreeMem( Buf );
   CloseFile( CertFile );
   CertFreeCertificateContext( pCertCon );
   CertCloseStore( hStore,0 );
  end;
  except
   on E:EOSError do
    Result := E.ErrorCode;
   on E:EInOutError do
    Result := E.ErrorCode;
  end;
end;

function ExportCert( const Store, CertName, FileName: string ): Integer;
var hStore : HCERTSTORE;
    pCertCon :PCCERT_CONTEXT;
    CertFile: file;
    Len : Integer;
begin
 try
  hStore := CertOpenSystemStore( 0, pChar( Store ) );
  if not Assigned( HStore ) then RaiseLastOSError;
  try
   pCertCon := CertFindCertificateInStore( hStore, X509_ASN_ENCODING or PKCS_7_ASN_ENCODING,
    0, CERT_FIND_SUBJECT_STR_A, pChar(CertName), nil );
   if not Assigned( pCertCon ) then RaiseLastOSError;
   try
    AssignFile( CertFile, FileName );
    ReWrite( CertFile, 1 );
    BlockWrite( CertFile, pCertCon^.pbCertEncoded^, pCertCon^.cbCertEncoded, Len );
    Result := 0;
   finally
    CloseFile( CertFile );
   end;
  finally
   CertFreeCertificateContext( pCertCon );
   CertCloseStore( hStore, 0 );
  end;
 except
  on E:EOSError do
   Result := E.ErrorCode;
  on E:EInOutError do
   Result := E.ErrorCode;
 end;

end;

function ExportCert( const Store: string; CertID: Pointer; FileName: string ): Integer;
var hStore : HCERTSTORE;
    pCertCon :PCCERT_CONTEXT;
    CertFile: file;
    Len : Integer;
begin
 try
  hStore := CertOpenSystemStore( 0, pChar( Store ) );
  if not Assigned( HStore ) then RaiseLastOSError;
  try
   pCertCon := CertFindCertificateInStore( hStore, X509_ASN_ENCODING or PKCS_7_ASN_ENCODING,
    0, CERT_FIND_CERT_ID, CertID, nil );
   if not Assigned( pCertCon ) then RaiseLastOSError;
   try
    AssignFile( CertFile, FileName );
    ReWrite( CertFile, 1 );
    BlockWrite( CertFile, pCertCon^.pbCertEncoded^, pCertCon^.cbCertEncoded, Len );
    Result := 0;
   finally
    CloseFile( CertFile );
   end;
  finally
   CertFreeCertificateContext( pCertCon );
   CertCloseStore( hStore, 0 );
  end;
 except
  on E:EOSError do
   Result := E.ErrorCode;
  on E:EInOutError do
   Result := E.ErrorCode;
 end;

end;

function DeleteCert( const StoreName, CertName : string): Integer;
var hStore : HCERTSTORE;
    pCertCon :PCCERT_CONTEXT;
begin
 try
  hStore := CertOpenSystemStore( 0, pChar( StoreName ) );
  if not Assigned( HStore ) then RaiseLastOSError;
  try
   pCertCon := CertFindCertificateInStore( hStore, X509_ASN_ENCODING or PKCS_7_ASN_ENCODING,
    0, CERT_FIND_SUBJECT_STR_A, pChar(CertName), nil );
   if not Assigned( pCertCon ) then RaiseLastOSError;
   Win32Check( CertDeleteCertificateFromStore( pCertCon ) );
   Result := 0;
  finally;
   CertCloseStore( hStore, 0 );
  end;
 except
  on E:EOSError do
   Result := E.ErrorCode;
 end;
end;

function DeleteCert( const StoreName : string; CertID: Pointer ): Integer;
var hStore : HCERTSTORE;
    pCertCon :PCCERT_CONTEXT;
begin
 try
  hStore := CertOpenSystemStore( 0, pChar( StoreName ) );
  if not Assigned( HStore ) then RaiseLastOSError;
  try
   pCertCon := CertFindCertificateInStore( hStore, X509_ASN_ENCODING or PKCS_7_ASN_ENCODING,
    0, CERT_FIND_CERT_ID, CertID, nil );
   if not Assigned( pCertCon ) then RaiseLastOSError;
   Win32Check( CertDeleteCertificateFromStore( pCertCon ) );
   Result := 0;
  finally;
   CertCloseStore( hStore, 0 );
  end;
 except
  on E:EOSError do
   Result := E.ErrorCode;
 end;
end;
//////////////////////////////////////////////////////////////
// displaying cert context
//////////////////////////////////////////////////////////////
function ByteArrayToStr( pb : Pointer; cb: Integer) : string;
var i,j: Integer;
 s : string;
begin
 if not Assigned(pb) or (cb<=0) then Exit;
 Result := '';
 for i := 0 to cb-1 do
 begin
  j := pByteArray(pb)^[i];
  s := IntToHex( j,2 );
  if (i>0) and (i mod 2 = 0) then s := s + ' ';
  Result := s + Result;//reverse order
 end;
end;

function GetIssuer( CertCon :PCCERT_CONTEXT ): string;
var buf : array[0..4095] of Byte;
 Res : DWORD;
begin
 Res := CertNameToStr( CertCon.dwCertEncodingType, CertCon.pCertInfo.Issuer,
 CERT_X500_NAME_STR, @buf, SizeOf(Buf) );
 if Res>0 then
  Result := string( pChar( @buf) )
 else
  Result := '';
end;

function GetSubject( CertCon :PCCERT_CONTEXT ): string;
var buf : array[0..4095] of Byte;
 Res : DWORD;
begin
 Res := CertNameToStr( CertCon.dwCertEncodingType, CertCon.pCertInfo.Subject,
 CERT_X500_NAME_STR, @buf, SizeOf(Buf) );
 if Res>0 then
  Result := string( pChar( @buf) )
 else
  Result := '';
end;

function GetRDNItem( RDNStr: string; Name: string) : string;
var  sl : TStringList;
begin
 try
  try
   sl := TStringList.Create;
   sl.Text := RDNStr;
   Result := sl.Values[ Name ];
  except
   Result := '';
  end;
 finally
  sl.Free;
 end
end;

function GetIssuerRDNItem( CertCon :PCCERT_CONTEXT; Item : string = 'CN' ): string;
var buf : array[0..4095] of Byte;
 Res : DWORD;
begin
 Res := CertNameToStr( CertCon.dwCertEncodingType, {@}CertCon.pCertInfo.Issuer,
 CERT_X500_NAME_STR or CERT_NAME_STR_CRLF_FLAG, @buf, SizeOf(buf) );
 if Res>0 then
  Result := GetRDNItem( string(pChar(@Buf)), Item )
 else
  Result := '';
end;

function GetSubjectRDNItem( CertCon :PCCERT_CONTEXT; Item : string = 'CN' ): string;
var buf : array[0..4095] of Byte;
 Res : DWORD;
begin
 Res := CertNameToStr( CertCon.dwCertEncodingType, CertCon.pCertInfo.Subject,
 CERT_X500_NAME_STR or CERT_NAME_STR_CRLF_FLAG, @buf, SizeOf(buf) );
 if Res>0 then
  Result := GetRDNItem( string(pChar(@Buf)), Item )
 else
  Result := '';
end;

function GetNameString( CertCon :PCCERT_CONTEXT; IssuerFlag : Integer = 0 ): string;
var i: Integer;
 wch : array[0..511] of Char;
begin
i := CertGetNameString( CertCon,
     CERT_NAME_SIMPLE_DISPLAY_TYPE,
     IssuerFlag ,
     nil,
     LPCSTR( @wch ),
     SizeOf( wch ) );
 if i>1 then
  Result := string( LPCSTR(@wch) )
 else
  Result := '';
end;

function GetSignatureAlgorithm( CertCon :PCCERT_CONTEXT ): string;
begin
 Result := pChar( CertCon.pCertInfo.SignatureAlgorithm.pszObjId );
end;

function GetSerialNumber( CertInfo: PCERT_INFO ): string;
begin
 Result := ByteArrayToStr( CertInfo.SerialNumber.pbData, CertInfo.SerialNumber.cbData );
end;

function GetValidFrom( CertCon :PCCERT_CONTEXT ): string;
var st : TSystemTime;
begin
 if FileTimeToSystemTime( CertCon.pCertInfo.NotBefore, st ) then
  Result := DateTimeToStr( SystemTimeToDateTime( st ) )
 else
  Result := '';
end;

function GetValidTo( CertCon :PCCERT_CONTEXT ): string;
var st : TSystemTime;
begin
 if FileTimeToSystemTime( CertCon.pCertInfo.NotAfter, st ) then
  Result := DateTimeToStr( SystemTimeToDateTime( st ) )
 else
  Result := '';
end;

procedure GetCertConextInfo( CertCon :PCCERT_CONTEXT; InfoList : TStrings );
begin
 InfoList.Add( 'Nr seryjny: '+ GetSerialNumber( CertCon.pCertInfo ) );
 InfoList.Add( 'Wany od: '+ GetValidFrom( CertCon ) );
 InfoList.Add( 'Wany do: '+ GetValidTo( CertCon ) );

 //InfoList.Add( 'Wystawca (skrt): '+ GetIssuerShort( CertCon ) );
 InfoList.Add( 'Wystawca : '+ GetIssuer( CertCon ) );
 //InfoList.Add( 'Podmiot (skrt): '+ GetSubjectShort( CertCon ) );
 InfoList.Add( 'Podmiot: '+ GetSubject( CertCon ) );
 InfoList.Add( 'Algorytm podpisu: '+ GetSignatureAlgorithm( CertCon ) );
end;

function GetCertificateInfo( StoreName, CertName: string; InfoList : TStrings ): Integer;
var hStore : HCERTSTORE;
    pCertCon :PCCERT_CONTEXT;
begin
try
 try
  hStore := CertOpenSystemStore( 0, pChar(StoreName) );
  if not Assigned( HStore ) then RaiseLastOSError;
  pCertCon := CertFindCertificateInStore( hStore, X509_ASN_ENCODING or PKCS_7_ASN_ENCODING,
    0, CERT_FIND_SUBJECT_STR_A, pChar(CertName), nil );
  if not Assigned( pCertCon ) then RaiseLastOSError;
  GetCertConextInfo( pCertCon, InfoList );
  Result := 0;
  ///////
 finally
  if Assigned( pCertCon ) then CertFreeCertificateContext( pCertCon );
  if Assigned( HStore ) then CertCloseStore( hStore,0 );
 end;
except
 on E:EOSError do
  Result := E.ErrorCode;
end;
end;

function GetCertificateInfo( StoreName : string; CertID: Pointer; InfoList : TStrings ): Integer;
var hStore : HCERTSTORE;
    pCertCon :PCCERT_CONTEXT;
begin
try
 try
  hStore := CertOpenSystemStore( 0, pChar(StoreName) );
  if not Assigned( HStore ) then RaiseLastOSError;
  pCertCon := CertFindCertificateInStore( hStore, X509_ASN_ENCODING or PKCS_7_ASN_ENCODING,
    0, CERT_FIND_CERT_ID, CertID, nil );
  if not Assigned( pCertCon ) then RaiseLastOSError;
  GetCertConextInfo( pCertCon, InfoList );
  Result := 0;
  ///////
 finally
  if Assigned( pCertCon ) then CertFreeCertificateContext( pCertCon );
  if Assigned( HStore ) then CertCloseStore( hStore,0 );
 end;
except
on E:EOSError do
  Result := E.ErrorCode;
end;

end;

type
 PCRYPTOAPI_BLOB = ^CRYPTOAPI_BLOB;

function CopyBlob ( ABlob : PCRYPTOAPI_BLOB ): PCRYPTOAPI_BLOB;
begin
 New( Result );
 Result.cbData := ABlob.cbData;
 GetMem( Result.pbData, Result.cbData );
 Move( ABlob.pbData^, Result.pbData^, Result.cbData );
end;

Procedure FreeCertID( AnID : Pointer );
begin
try
 with PCERT_ID( AnID )^ do
 if dwIdChoice = CERT_ID_ISSUER_SERIAL_NUMBER then
  begin
   if Assigned( IssuerSerialNumber.Issuer.pbData ) then
    FreeMem( IssuerSerialNumber.Issuer.pbData, IssuerSerialNumber.Issuer.cbData );
   if Assigned( IssuerSerialNumber.SerialNumber.pbData ) then
    FreeMem( IssuerSerialNumber.SerialNumber.pbData, IssuerSerialNumber.SerialNumber.cbData );
  end;
 Dispose( AnID );
except
end;
end;

function ListCerts( StoreName: string; List : TStrings ): boolean;
var hStore : HCERTSTORE;
    pCertCon :PCCERT_CONTEXT;
    i,j: Integer;
    s : string;
    ID : PCERT_ID;
begin
 try
   try
    hStore := CertOpenSystemStore( 0, LPCSTR(StoreName) );
    if not Assigned(hStore) then RaiseLastOSError;
    pCertCon := nil;
    j := 1;
    repeat
    pCertCon := CertEnumCertificatesInStore( hStore, pCertCon );
    if pCertCon = nil then break;
    New( ID );
    ID^.dwIdChoice := CERT_ID_ISSUER_SERIAL_NUMBER;
    ID^.IssuerSerialNumber.Issuer := CopyBlob( @pCertCon.pCertInfo.Issuer )^;
    ID^.IssuerSerialNumber.SerialNumber := CopyBlob( @pCertCon.pCertInfo.SerialNumber )^;
    List.AddObject( Format('%s,%s,"%s","%s"',
     [ AnsiQuotedStr( GetNameString( pCertCon ), '"' ),
       AnsiQuotedStr( GetNameString( pCertCon, CERT_NAME_ISSUER_FLAG ), '"' ),
       GetValidTo( pCertCon ),
       GetSerialNumber( pCertCon.pCertInfo ) ]
     ),
     TObject( ID ) );
    until False;

   finally
    if Assigned(pCertCon) then CertFreeCertificateContext( pCertCon );
    CertCloseStore( hStore, 0 );
   end;
  except

  end;

end;


function SysStoreCallback(
    pvSystemStore: pointer;
    dwFlags: DWORD;
    pStoreInfo: PCERT_SYSTEM_STORE_INFO;
    pvReserved: pointer;
    pvArg: pointer
    ): BOOL; stdcall;
begin
 if Assigned( pvArg ) then
 try
  TStrings(pvArg).Add( string (LPCWSTR( pvSystemStore )));
  Result := True;
 except
  Result := False;
 end;
end;

function ListSystemStores( List : TStrings ): boolean;
begin
 List.Clear;
 Result :=
  CertEnumSystemStore(
 //CERT_SYSTEM_STORE_LOCAL_MACHINE,
 CERT_SYSTEM_STORE_CURRENT_USER,
 //CERT_SYSTEM_STORE_LOCAL_MACHINE_ENTERPRISE,
 nil, Pointer(List),
 SysStoreCallback );
end;


  { bufsize := SizeOf( buf );
  dw := 0;
  repeat
   dw := CertEnumCertificateContextProperties( pCertCon, dw );
   if dw>0 then
    if CertGetCertificateContextProperty( pCertCon, dw, @buf, @bufsize) then
      begin
        s:= ByteArrayToStr( @buf, dw );
        InfoList.Add(s);
      end;
    bufsize := SizeOf( buf );
  until dw=0;}

  (*
 if CryptDecodeObject( CertCon.dwCertEncodingType, X509_NAME,
     CertCon.pCertInfo.Issuer.pbData, CertCon.pCertInfo.Issuer.cbData, 0,
     PVOID( @Buf ), @bufsize) then
       Result := pChar(@buf);
     {with PCERT_NAME_INFO(@buf)^ do
     begin
      i := cRDN;
      for j := 0 to i-1 do
      begin
       ia :=
      end; //for

      s:= pChar(@Buf);
      InfoList.Add(s);
     end;}
 *)

 ///////
 (* bufsize := SizeOf( buf );

  if CertGetEnhancedKeyUsage( pCertCon, 0, PCERT_ENHKEY_USAGE(@buf), @bufsize) then
   begin
    pCh := PCERT_ENHKEY_USAGE(@buf)^.rgpszUsageIdentifier;
    i := PCERT_ENHKEY_USAGE(@buf)^.cUsageIdentifier;
    for j := 0 to i-1 do
    begin
     s := string(pChar( pCh^));
     Inc( Cardinal(pCh), 4);
     InfoList.Add(s);
    end; //for
    //s:= ByteArrayToStr( @buf, bufsize );

   end
  else
     s := SysErrorMessage( GetLastError );
  *) 
end.
