unit uSimpleRDM;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, ComServ, ComObj, VCLCom, DataBkr,
  DBClient, SimpleAppSrvr_TLB, StdVcl, uSecondary, DB, DBTables, Provider,
  ADODB;

type
  TSimpleRDM = class(TRemoteDataModule, ISimpleRDM)
    dspEmployees: TDataSetProvider;
    dspOrders: TDataSetProvider;
    dspCustomers: TDataSetProvider;
    conMastApp: TADOConnection;
    tblEmplyees: TADOTable;
    tblCustomers: TADOTable;
    tblOrders: TADOTable;
    procedure conMastAppBeforeConnect(Sender: TObject);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    function Get_Secondary: Secondary; safecall;
  public
    { Public declarations }
  end;


implementation

uses uSimpleAppSrvr;


{$R *.DFM}

class procedure TSimpleRDM.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

function TSimpleRDM.Get_Secondary: Secondary;
begin
 Result := FSecondaryFactory.CreateCOMObject(nil) as ISecondary;
end;

procedure TSimpleRDM.conMastAppBeforeConnect(Sender: TObject);
begin
 if fmMain.edDataPath.Text <> ''
  then conMastApp.ConnectionString := 'Provider=Microsoft.Jet.OLEDB.4.0;Persist Security Info=False;Data Source=' + fmMain.edDataPath.Text
  else Abort;
end;

initialization
  TComponentFactory.Create(ComServer, TSimpleRDM,
    Class_SimpleRDM, ciMultiInstance, tmApartment);
end.

