unit uDMTest1;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComServ, ComObj, VCLCom, StdVcl, bdemts, DataBkr, DBClient,
  MtsRdm, Mtx, MTSServer1_TLB, DB, ADODB, DBTables;

type
  TDMTest1 = class(TMtsDataModule, IDMTest1)
    conDBDemos: TADOConnection;
    quOrdCount: TADOQuery;
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean; const ClassID, ProgID: string); override;
    procedure GetOrderCount(out OrdCount: Integer); safecall;
  public
    { Public declarations }
  end;

var
  DMTest1: TDMTest1;

implementation

{$R *.DFM}

const DefOrdCount: Integer = -1;

class procedure TDMTest1.UpdateRegistry(Register: Boolean; const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;


procedure TDMTest1.GetOrderCount(out OrdCount: Integer);
begin
 try
  conDBDemos.Open;
  try
   quOrdCount.Open;
   OrdCount := quOrdCount.Fields[0].AsInteger;
   quOrdCount.Close;
  finally
   conDBDemos.Close;
  end;
  SetComplete;
 except
  OrdCount := DefOrdCount;
  SetAbort;
 end;
end;

initialization
  TComponentFactory.Create(ComServer, TDMTest1,
    Class_DMTest1, ciMultiInstance, tmApartment);
end.