unit uDistObject;
{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ActiveX, Mtsobj, Mtx, ComObj, DistrObject_TLB, MTSServer1_TLB, MTSServer2_TLB, StdVcl;

type
  TDistrObject = class(TMtsAutoObject, IDistrObject)
  private
    DMTest1: IDMTest1;
    DMTest2: IDMTest2;
  protected
    procedure ExecTransaction(out OrdCount, CustCount: Integer); safecall;
  end;

implementation

uses ComServ, sysutils;

procedure WriteDebug(AStr: String);
var DebugFile: TextFile;
begin
 {$I-}
 AssignFile(DebugFile, 'c:\temp\mtsdebug.txt');
 if FileExists('c:\temp\mtsdebug.txt')
  then Append(DebugFile)
  else Rewrite(DebugFile);
 Writeln(DebugFile, AStr);
 CloseFile(DebugFile);
 {$I+}
end;

procedure TDistrObject.ExecTransaction(out OrdCount, CustCount: Integer);
begin
 try
  OleCheck(ObjectContext.CreateInstance(CLASS_DMTest1,IDMTest1, DMTest1));
  OleCheck(ObjectContext.CreateInstance(CLASS_DMTest2,IDMTest2, DMTest2));
  DMTest1.GetOrderCount(OrdCount);
  DMTest2.GetCustCount(CustCount);
  EnableCommit;
 except
  DisableCommit;
 end;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TDistrObject, Class_DistrObject,
    ciMultiInstance, tmBoth);
end.
