unit WebMainU;
//----------------------------------------------------
//*
//* Prosta przegldarka WWW - demo
//* (C) 2001 Andrzej Grayski, HELION Publishing
//*
//----------------------------------------------------

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, OleCtrls, SHDocVw, ComCtrls, Buttons;

type
  TWebMain = class(TForm)
    Panel1: TPanel;
    URLComboBox: TComboBox;
    StatusBar: TStatusBar;
    WebBrowser1: TWebBrowser;
    btnBackward: TBitBtn;
    btnForward: TBitBtn;
    btnHome: TBitBtn;
    btnSearch: TBitBtn;
    btnRefresh: TBitBtn;
    procedure URLComboBoxKeyPress(Sender: TObject; var Key: Char);
    procedure URLComboBoxDblClick(Sender: TObject);
    procedure btnBackwardClick(Sender: TObject);
    procedure btnForwardClick(Sender: TObject);
    procedure btnHomeClick(Sender: TObject);
    procedure btnSearchClick(Sender: TObject);
    procedure WebBrowser1ProgressChange(Sender: TObject; Progress,
      ProgressMax: Integer);
    procedure btnRefreshClick(Sender: TObject);
    procedure WebBrowser1DownloadComplete(Sender: TObject);
    procedure WebBrowser1BeforeNavigate2(Sender: TObject;
      const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
      Headers: OleVariant; var Cancel: WordBool);
    procedure WebBrowser1DownloadBegin(Sender: TObject);
  private
    procedure UpdateURL;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  WebMain: TWebMain;

implementation

{$R *.dfm}

procedure TWebMain.UpdateURL;
var
  S: String;
begin
  S := WebBrowser1.LocationURL;
  if S<>''
  then
    URLComboBox.Text := WebBrowser1.LocationURL;
end;


procedure TWebMain.URLComboBoxKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = Char(VK_RETURN) then
  begin
    Key := #0;
    if URLComboBox.Text<>''  then
    begin
      WebBrowser1.Navigate(URLComboBox.Text);
    end;
  end;
end;

procedure TWebMain.URLComboBoxDblClick(Sender: TObject);
var
  C: Char;
begin
  C := Char(VK_RETURN);
  URLComboBoxKeyPress(Sender, C);
end;

procedure TWebMain.btnBackwardClick(Sender: TObject);
begin
  WebBrowser1.GoBack;
end;

procedure TWebMain.btnForwardClick(Sender: TObject);
begin
  WebBrowser1.GoForward;
end;

procedure TWebMain.btnHomeClick(Sender: TObject);
begin
  WebBrowser1.GoHome;
  UpdateURL;
end;

procedure TWebMain.btnSearchClick(Sender: TObject);
begin
  WebBrowser1.GoSearch;
end;

procedure TWebMain.WebBrowser1ProgressChange(Sender: TObject; Progress,
  ProgressMax: Integer);
var
  Percent: integer;
begin
  if (ProgressMax <= 0) or (Progress < 0)  then
  begin
    StatusBar.SimpleText := 'Gotowe';
  end
  else
  begin
    Percent := (Progress * 100) div ProgressMax;

    StatusBar.SimpleText := Format(
        'Pobieranie strony: %d%% z %dK', [Percent, ProgressMax div 1024]);
  end;
end;

procedure TWebMain.btnRefreshClick(Sender: TObject);
begin
  if URLComboBox.Text<>''  then
  begin
    WebBrowser1.Navigate(URLComboBox.Text)
  end
  else
  begin
    WebBrowser1.Refresh;
  end;
end;

procedure TWebMain.WebBrowser1DownloadComplete(Sender: TObject);
begin
  StatusBar.SimpleText := 'Gotowe';
  UpdateURL;
  URLComboBox.Items.Insert(0, URLComboBox.Text);
end;


procedure TWebMain.WebBrowser1BeforeNavigate2(Sender: TObject;
  const pDisp: IDispatch; var URL, Flags, TargetFrameName, PostData,
  Headers: OleVariant; var Cancel: WordBool);
begin
  StatusBar.SimpleText := 'czenie z serwerem ...';
end;

procedure TWebMain.WebBrowser1DownloadBegin(Sender: TObject);
begin
  StatusBar.SimpleText := 'Poczono';
end;

end.

