unit FlashingLabel;

interface

{$R Flashinglabel.dcr}
 
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls;
 
type
 
  TLimitReachedEvent =
    procedure(Sender : TObject; var Stop : Boolean) of object;
 
  TFlashingLabel = class(TCustomLabel)
  private
    { Private declarations }
    FFlashEnabled   : Boolean;
    FFlashLimit     : Integer;
    FFlashRate      : Integer;
    FOnLimitReached : TLimitReachedEvent;
 
    FlashCount      : Integer;
    Timer           : TTimer;
  protected
    { Protected declarations }
 
    { Chronione metody write, przeznaczone dla waciwoci }
    procedure SetFlashEnabled(AFlashEnabled : Boolean);
    procedure SetFlashRate(AFlashRate : Integer);
    procedure DoLimitReached; virtual;
    procedure Click; override;
 
    { Funkcja obsugujca zdarzenie OnTimer }
    procedure OnTimer(Sender : TObject); virtual;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
  published
    { Published declarations }
 
    { Waciwoci komponentu }
    property FlashEnabled : Boolean
      read FFlashEnabled write SetFlashEnabled default True;
    property FlashRate : Integer
      read FFlashRate write SetFlashRate default 800;
    property FlashLimit : Integer
      read FFlashLimit write FFlashLimit default 0;
 
    property OnLimitReached : TLimitReachedEvent
      read FOnLimitReached write FOnLimitReached;
 
    { Deklaracje waciwoci klasy TCustomLabel }
    property Align;
    property Alignment;
    property AutoSize;
    property BiDiMode;
    property Caption;
    property Color;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentBiDiMode;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Layout;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
  end;

procedure Register;
 
implementation
 
constructor TFlashingLabel.Create(AOwner : TComponent);
begin
  inherited;
 
  { Przypisanie wartoci domylnych polom danych }
  FFlashEnabled := True;
  FFlashRate    := 800;
  FFlashLimit   := 0;
  FlashCount    := 0;
 
  { Inicjalizacja obiektu timera. }
  Timer := TTimer.Create(Self);
 
  { Ustawienie przedziau timera przy uyciu wsp. migotania }
  Timer.Interval := FFlashRate;
 
  { Przypisanie wasnej funkcji obsugujcej zdarzenie OnTimer }
  { do zdarzenia OnTimer }
  Timer.OnTimer := OnTimer;
end;
 
procedure TFlashingLabel.SetFlashEnabled(AFlashEnabled : Boolean);
begin
  { Ustawienie pola FFlashEnabled }
  FFlashEnabled := AFlashEnabled;
  { Nie uruchamiaj timera, jeeli komponent w formularzu }
  { znajduje si w trybie projektowania. Powrt z procedury }
 
  if csDesigning in ComponentState then
    Exit;
 
  { Uruchomienie timera }
  Timer.Enabled := FFlashEnabled;
 
  { Jeeli migotanie zostao wyczone, trzeba upewni si, }
  { e etykieta jest widoczna. }
  if not FFlashEnabled then
    Visible := True;
end;
 
procedure TFlashingLabel.SetFlashRate(AFlashRate : Integer);
begin
  { Ustawienie pola FFlashRate i przedziau czasowego timera }
  FFlashRate := AFlashRate;
  Timer.Interval := AFlashRate;
end;
procedure TFlashingLabel.OnTimer(Sender : TObject);
begin
  { Jeeli komponent znajduje si w formularzu w trybie }
  { projektowania, nastpuje zatrzymanie timera i powrt }
  if csDesigning in ComponentState then begin
    Timer.Enabled := False;
    Exit;
  end;
 
  { Zmiana stanu waciwoci Visible za kadym razem, kiedy }
  { pojawia si zdarzenie timera }
  Visible := not Visible;
 
  { W miar potrzeby wywoanie zdarzenia. Zwikszenie licznika, }
  { jeeli etykieta jest widoczna. }
  { Wygenerowanie zdarzenia, gdy istnieje konieczno }
  if (FFlashLimit <> 0) and Visible then 
  begin
 
    { Zwikszenie pola FlashCount }
    Inc(FlashCount);
 
    { Jeeli pole FlashCount jest wiksze lub rwne }
    { wartoci waciwoci FlashLimit, nastpuje wyzerowanie }
    { wartoci FlashCount i wywoanie zdarzenia. }
    if FlashCount >= FFlashLimit then begin
      FlashCount := 0;
      DoLimitReached;
    end;
  end;
end;
 
procedure TFlashingLabel.DoLimitReached;
var
  Stop : Boolean;
begin
  Stop := False;
  if Assigned(FOnLimitReached) then
    FOnLimitReached(Self, Stop);
  FlashEnabled := not Stop;
end;
 
procedure TFlashingLabel.Click;
begin
  { Wydanie dwiku, a nastpnie wywoanie metody Click klasy }
  { podstawowej w celu przeprowadzenia domylnej obsugi zdarzenia. }
  MessageBeep(0);
  inherited;
end;

procedure Register;
begin
  RegisterComponents('Samples', [TFlashingLabel]);
end;

end.


