library MyForms;

uses
  SysUtils,
  Classes,
  Forms,
  Windows,
  AboutU in 'AboutU.pas' {DllForm},
  MDIChilU in 'MDIChilU.pas' {MDIChild};

var
  DllApp : TApplication;

function GetMyForm(AOwner : TComponent) : TForm;
begin
  Result := TForm(TDllAbout.Create(AOwner));
end;

procedure ShowMDIChild(MainApp : TApplication);
var
  Child : TMDIChild;
begin
  { Application switcheroo. }
  if not Assigned(DllApp) then begin
    DllApp := Application;
    Application := MainApp;
  end;
  { Create and show the MDI child form. }
  Child := TMDIChild.Create(Application.MainForm);
  Child.Show;
end;

procedure MyDLLProc(Reason: Integer);
begin
  if Reason = DLL_PROCESS_DETACH then
    { DLL is unlaoding. Restore the Application pointer. }
    if Assigned(DllApp) then
      Application := DllApp;
end;

exports
  GetMyForm,
  ShowMDIChild;

begin
  DLLProc := @MyDLLProc;
end.
