unit MakeTblU;
 
interface
 
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Grids, DBGrids, DbTables, Db;
 
type
  TForm2 = class(TForm)
    DBGrid: TDBGrid;
    CreateBtn: TButton;
    FillBtn: TButton;
    procedure CreateBtnClick(Sender: TObject);
    procedure FillBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
 
var
  Form2: TForm2;
 
implementation
 
{$R *.DFM}
 
procedure TForm2.CreateBtnClick(Sender: TObject);
const
  Dir : PChar = 'c:\mydata';
var
  Table : TTable;
begin
  { Utworzenie aliasu BDE, o ile nie istnia on }
  { do tej pory. }
 
  if not Session.IsAlias('MyDatabase') then begin
    CreateDirectory(Dir, nil);
    try
      Session.AddStandardAlias('MyDatabase', Dir, 'PARADOX');
      Session.SaveConfigFile;
    except
      MessageDlg('Error Creating Alias', mtError, [mbOk], 0);
      Exit;
    end;
  end;
  Screen.Cursor := crHourGlass;
  { Utworzenie tabeli, }
  Table := TTable.Create(Self);
  try
    Table.DatabaseName := 'MyDatabase';
    Table.TableName := 'MyTable.db';
 
    { Dodanie definicji pl. }
    Table.FieldDefs.Add('CustNo', ftFloat, 0, True);
    Table.FieldDefs.Add('Customer', ftString, 30, False);
    Table.FieldDefs.Add('Addr1', ftString, 30, False);
    Table.FieldDefs.Add('Addr2', ftString, 30, False);
    Table.FieldDefs.Add('City', ftString, 15, False);
    Table.FieldDefs.Add('State', ftString, 20, False);
    Table.FieldDefs.Add('Zip', ftString, 10, False);
    Table.FieldDefs.Add('Phone', ftString, 15, False);
    Table.FieldDefs.Add('Fax', ftString, 15, False);
 
    { Dodanie definicji indeksu dla klucza gwnego }
    Table.IndexDefs.Add('', 'CustNo', [ixPrimary]);
    { Po dokonaniu wszelkich ustawie mona utworzy tabel. }
    Table.CreateTable;
  except
    MessageDlg('Error Creating Table', mtError, [mbOk], 0);
    Screen.Cursor := crDefault;
    Table.Free;
    Exit;
  end;
 
  { Poinformowanie uytkownika o zakoczeniu procesu tworzenia.}
  Table.Free;
  Screen.Cursor := crDefault;
  CreateBtn.Enabled := False;
  FillBtn.Enabled := True;
  MessageDlg('Table Created Successfully', mtInformation, [mbOk], 0);
end;
 
procedure TForm2.FillBtnClick(Sender: TObject);
var
  Table      : TTable;
  Datasource : TDataSource;
  Lines      : TStringList;
  S, S2      : string;
  I, P       : Integer;
begin
  { Create a TTable. }
  Table := TTable.Create(Self);
  Table.DatabaseName := 'MyDatabase';
  Table.TableName := 'MyTable.db';
 
  { Utworzenie obiektu rda danych i poczenie go }
  { z tabel. Poczenie obiektu siatki ze rdem danych. }
  Datasource := TDataSource.Create(Self);
  Datasource.DataSet := Table;
  DBGrid.Datasource := Datasource;
 
  { Otwarcie tabeli i pliku tekstowego. }
  Table.Active := True;
  Lines := TStringList.Create;
  Lines.LoadFromFile('customer.txt');
 
  { Ustawienie tabeli w tryb edycji. }
  Table.Edit;
 
  { Przetwarzanie kolejnych linii waciwoci Lines. }
  for I := 0 to Pred(Lines.Count) do begin
    { Dodanie rekordu do koca zbioru. }
    Table.Append;
 
    { Rozczonkowanie acucha w celu uzyskania pierwszego czonu }
 
    S := Lines[I];
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
 
    { Zapisanie wartoci w polu CustNo. }
    Table.FieldByName('CustNo').Value := StrToInt(S2);
 
    { Powtrzenie tego samego procesu dla pozostaych pl. }
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('Customer').Value := S2;
 
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('Addr1').Value := S2;
 
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('Addr2').Value := S2;
 
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('City').Value := S2;
 
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('State').Value := S2;
 
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('Zip').Value := S2;
 
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('Phone').Value := S2;
 
    P := Pos(',', S);
    S2 := Copy(S, 1, P - 1);
    Delete(S, 1, P);
    Table.FieldByName('FAX').Value := S2;
 
    { Przy prbie dodania rekordu o takim samym numerze klienta otrzymamy }
    { wyjtek naruszenia unikatowoci klucza. Jeeli tak si zdarzy, }
    { musimy poinformowa o tym uytkownika, anulowa modyfikacj,  }  
    { przywrci tabel do trybu edycji i kontynuowa przetwarzanie } 
    { kolejnych linii. }
    try
      Table.Post;
    except
      on EDBEngineError do begin
        MessageBox(Handle,
          'Powtrzony numer klienta', 'Key Violation', 0);
        Table.Cancel;
        Table.Edit;
        Continue;
      end;
    end;
  end;

  { Obiekt klasy TStringList nie jest ju duej potrzebny, }
  { mona wic go zwolni. }
  Lines.Free;

  { Nie bdziemy usuwa z pamici tabeli, dziki czemu jej dane }
  { bd dalej wywietlane przez obiekt DBGrid. Zwolnienia tabeli }
  { i rda danych dokona za nas VCL. }

  {Table.Free; }
  {Datasource.Free; }
end;

end.


