unit DynTablU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, Grids, DBGrids, StdCtrls;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    DBNamesComboBox: TComboBox;
    TablesComboBox: TComboBox;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Table1: TTable;
    procedure DBNamesComboBoxChange(Sender: TObject);
    procedure TablesComboBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.DBNamesComboBoxChange(Sender: TObject);
var
  DBName : string;
  DB : TDatabase;
begin
  if Table1.Active then
    Table1.Active := False;
  TablesComboBox.Text := '';
  DBName := DBNamesComboBox.Text;
  DB := TDatabase.Create(Self);
  DB.AliasName := DBName;
  if DB.IsSQLBased then
    Session.GetTableNames(DBName, '',
      False, True, TablesComboBox.Items)
  else
    Session.GetTableNames(DBName, '',
      True, False, TablesComboBox.Items);
  Table1.DatabaseName := DBName;
  TablesComboBox.DroppedDown := True;
  Table1.Filter := '';
  DB.Free;
end;


procedure TMainForm.TablesComboBoxChange(Sender: TObject);
begin
  if Table1.Active then
    Table1.Active := False;
  Table1.TableName := TablesComboBox.Text;
  Table1.Active := True;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Session.GetDatabaseNames(DBNamesComboBox.Items);
end;

end.
