unit DbFltrU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, StdCtrls, Grids, DBGrids;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    DBNamesComboBox: TComboBox;
    TablesComboBox: TComboBox;
    DBGrid1: TDBGrid;
    FieldsComboBox: TComboBox;
    ValueEdit: TEdit;
    OperatorComboBox: TComboBox;
    FilterBtn: TButton;
    DataSource1: TDataSource;
    Table1: TTable;
    procedure DBNamesComboBoxChange(Sender: TObject);
    procedure TablesComboBoxChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FilterBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.DBNamesComboBoxChange(Sender: TObject);
var
  DBName : string;
  DB : TDatabase;
begin
  if Table1.Active then
    Table1.Active := False;
  TablesComboBox.Text := '';
  DBName := DBNamesComboBox.Text;
  DB := TDatabase.Create(Self);
  DB.AliasName := DBName;
  if DB.IsSQLBased then
    Session.GetTableNames(DBName, '',
      False, True, TablesComboBox.Items)
  else
    Session.GetTableNames(DBName, '',
      True, False, TablesComboBox.Items);
  Table1.DatabaseName := DBName;
  TablesComboBox.DroppedDown := True;
  Table1.Filter := '';
  DB.Free;
end;

procedure TMainForm.TablesComboBoxChange(Sender: TObject);
begin
  if Table1.Active then
    Table1.Active := False;
  Table1.TableName := TablesComboBox.Text;
  Table1.Active := True;
  FieldsComboBox.Enabled := True;
  OperatorComboBox.Enabled := True;
  ValueEdit.Enabled := True;
  Table1.GetFieldNames(FieldsComboBox.Items);
  FieldsComboBox.Text := FieldsComboBox.Items[0];
  Table1.Filter := '';
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Session.GetDatabaseNames(DBNamesComboBox.Items);
end;

procedure TMainForm.FilterBtnClick(Sender: TObject);
begin
  Table1.Filter := FieldsComboBox.Text +
    ' ' + OperatorComboBox.Text + ' ''' + ValueEdit.Text + '''';
  Table1.Filtered := True;
end;

end.
