unit ComTestU;

interface

{ NOTE: The book's text creates IMultiply as a COM object.      }
{ This example creates IMultiply as an Automation object, not a }
{ COM object. The automation object allows direct access to the }
{ object's properties rather than using the Get and Put methods }
{ as described in the book.}

uses
  ComObj, ActiveX, ComTest_TLB;

type
  TMultiply = class(TAutoObject, IMultiply)
  private
    FX : Integer;
    FY : Integer;
  protected
    function DoIt: Integer; safecall;
    function Get_X: Integer; safecall;
    function Get_Y: Integer; safecall;
    procedure Set_X(Value: Integer); safecall;
    procedure Set_Y(Value: Integer); safecall;
    { Protected declarations }
  end;

implementation

uses ComServ;

function TMultiply.DoIt: Integer;
begin
  Result := FX * FY;
end;

function TMultiply.Get_X: Integer;
begin
  Result := FX;
end;

function TMultiply.Get_Y: Integer;
begin
  Result := FY;
end;

procedure TMultiply.Set_X(Value: Integer);
begin
  FX := Value;
end;

procedure TMultiply.Set_Y(Value: Integer);
begin
  FY := Value;
end;

initialization
  TAutoObjectFactory.Create(ComServer, TMultiply, Class_Multiply,
    ciMultiInstance, tmApartment);
end.
