unit CursTstU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

const
  crScope = 1;

type
  TMainForm = class(TForm)
    Label1: TLabel;
    DoIt: TButton;
    Time: TEdit;
    CursorGroup: TRadioGroup;
    procedure DoItClick(Sender: TObject);
    procedure CursorGroupClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}
{$R SCOPE.RES}

procedure TMainForm.DoItClick(Sender: TObject);
var
  I, Iterations : Integer;
  OldCursor     : TCursor;
begin
  Iterations := StrToInt(Time.Text);
  OldCursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  Application.ProcessMessages;
  for I := 0 to Iterations do begin
    Time.Text := IntToStr(I);
    Time.Repaint;
  end;
  Screen.Cursor := OldCursor;
end;

procedure TMainForm.CursorGroupClick(Sender: TObject);
begin
  case CursorGroup.ItemIndex of
    0 : Screen.Cursor := crDefault;
    1 : Screen.Cursor := TCursor(crScope);
    2 : Screen.Cursor := crCross;
    3 : Screen.Cursor := crDrag;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Screen.Cursors[crScope] := LoadCursor(HInstance, 'IDC_SCOPE');
end;

end.
