unit MPlayerU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MPlayer, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    MediaPlayer: TMediaPlayer;
    ScrollBar: TScrollBar;
    Timer: TTimer;
    OpenDialog: TOpenDialog;
    OpenBtn: TButton;
    LoopCheckBox: TCheckBox;
    procedure MediaPlayerClick(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
    procedure MediaPlayerNotify(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
    procedure ScrollBarScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure OpenBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.MediaPlayerClick(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
  if Button = btStop then begin
    MediaPlayer.Notify := False;
    MediaPlayer.Stop;
    Timer.Enabled := False;
    Exit;
  end;
  MediaPlayer.Notify := True;
  ScrollBar.Max := MediaPlayer.Length;
  Timer.Enabled := True;
end;

procedure TMainForm.MediaPlayerNotify(Sender: TObject);
begin
  if not LoopCheckBox.Checked then begin
    Timer.Enabled := False;
    ScrollBar.Position := 0;
    Exit;
  end;
  with MediaPlayer do
    if NotifyValue = nvSuccessful then begin
      Play;
    end;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
begin
  ScrollBar.Position := MediaPlayer.Position;
end;

procedure TMainForm.ScrollBarScroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  if MediaPlayer.Enabled = False then
    Exit;
  MediaPlayer.Position := ScrollBar.Position;
  MediaPlayer.Play;
end;

procedure TMainForm.OpenBtnClick(Sender: TObject);
begin
  if OpenDialog.Execute then begin
    MediaPlayer.FileName := OpenDialog.FileName;
    MediaPlayer.Enabled := True;
    MediaPlayer.Open;
    ScrollBar.Enabled := True;
  end;
end;

end.
