unit CDPlayU;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMSystem, MPlayer, StdCtrls, ExtCtrls;

type
  TForm3 = class(TForm)
    MediaPlayer: TMediaPlayer;
    Timer: TTimer;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure TimerTimer(Sender: TObject);
    procedure MediaPlayerClick(Sender: TObject; Button: TMPBtnType;
      var DoDefault: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

{$R *.DFM}

procedure TForm3.TimerTimer(Sender: TObject);
var
  Time    : Integer;
  Track   : Integer;
  Minutes : Integer;
  Seconds : Integer;
  TimeStr : string;
begin
  if MediaPlayer.Mode <> mpPlaying then
    Exit;
  Time    := MediaPlayer.Position;
  Track   := mci_TMSF_Track(Time);
  Minutes := mci_TMSF_Minute(Time);
  Seconds := mci_TMSF_Second(Time);
  TimeStr := Format('Track Time: %2.2d:%2.2d', [Minutes, Seconds]);
  Label1.Caption := 'Track: ' + IntToStr(Track);
  Label2.Caption := TimeStr;
  MediaPlayer.TimeFormat := tfMSF;
  Time := MediaPlayer.Position;
  Minutes := mci_MSF_Minute(Time);
  Seconds := mci_MSF_Second(Time);
  TimeStr := Format('Total Time: %2.2d:%2.2d', [Minutes, Seconds]);
  Label3.Caption := TimeStr;
  MediaPlayer.TimeFormat := tfTMSF;
end;

procedure TForm3.MediaPlayerClick(Sender: TObject; Button: TMPBtnType;
  var DoDefault: Boolean);
begin
  if Button = btEject then begin
    Label1.Caption := 'Track: ';
    Label2.Caption := 'Track Time: ';
    Label3.Caption := 'Total Time: ';
  end;
end;

end.
